/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropSymmetric
extends Propagator<SetVar> {
    private final int n;
    private int currentSet;
    private final int offSet;
    private final ISetDeltaMonitor[] sdm;
    private final IntProcedure elementForced;
    private final IntProcedure elementRemoved;

    public PropSymmetric(SetVar[] sets, int offSet) {
        super((Variable[])sets, (Priority)PropagatorPriority.LINEAR, true);
        this.n = sets.length;
        this.offSet = offSet;
        this.sdm = new ISetDeltaMonitor[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> ((SetVar[])this.vars)[element - offSet].force(this.currentSet + offSet, this);
        this.elementRemoved = element -> ((SetVar[])this.vars)[element - offSet].remove(this.currentSet + offSet, this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            ISetIterator iter = ((SetVar[])this.vars)[i].getUB().iterator();
            while (iter.hasNext()) {
                int j = iter.nextInt();
                if (j >= this.offSet && j < this.n + this.offSet && ((SetVar[])this.vars)[j - this.offSet].getUB().contains(i + this.offSet)) continue;
                ((SetVar[])this.vars)[i].remove(j, this);
            }
            iter = ((SetVar[])this.vars)[i].getLB().iterator();
            while (iter.hasNext()) {
                ((SetVar[])this.vars)[iter.nextInt() - this.offSet].force(i + this.offSet, this);
            }
        }
        for (i = 0; i < this.n; ++i) {
            this.sdm[i].startMonitoring();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.currentSet = idxVarInProp;
        this.sdm[this.currentSet].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        this.sdm[this.currentSet].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = ((SetVar[])this.vars)[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (((SetVar[])this.vars)[j - this.offSet].getUB().contains(i + this.offSet)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

