/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.view.IView;

public class GephiNetwork {
    private GephiNetwork() {
    }

    public static void write(String gexfFile, Model model) {
        int nodeCount = 1;
        int edgeCount = 1;
        StringBuilder nodes = new StringBuilder();
        StringBuilder edges = new StringBuilder();
        Path file = Paths.get(gexfFile, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList views = new ArrayList();
        for (Variable var : model.getVars()) {
            ++nodeCount;
            nodes.append(String.format("\t\t\t<node id=\"%s\" label=\"%s\" %s>\n\t\t\t\t%s\n\t\t\t\t%s\n\t\t\t</node>\n", var.getId(), var.getName(), "", "<viz:color r=\"191\" g=\"63\" b=\"63\" a=\"1\"/>", "<viz:shape value=\"disc\"/>"));
            for (int i = 0; i < var.getNbViews(); ++i) {
                views.add(var.getView(i));
            }
        }
        for (IView iView : views) {
            ++nodeCount;
            for (Variable observed : iView.getVariables()) {
                nodes.append(String.format("\t\t\t<node id=\"%s\" label=\"%s\" %s>\n\t\t\t\t%s\n\t\t\t\t%s\n\t\t\t</node>\n", iView.getId(), iView.getName(), "", "<viz:color r=\"191\" g=\"127\" b=\"63\" a=\"1\"/>", "<viz:shape value=\"diamond\"/>"));
                edges.append(String.format("\t\t\t<edge id=\"%s\" source=\"%s\" target=\"%s\" type=\"directed\"/>\n", edgeCount++, iView.getId(), observed.getId()));
            }
        }
        ++nodeCount;
        int c = 0;
        TIntHashSet tIntHashSet = new TIntHashSet();
        for (Constraint cstr : model.getCstrs()) {
            tIntHashSet.clear();
            String id = "c_" + ++c;
            nodes.append(String.format("\t\t\t<node id=\"%s\" label=\"%s\" %s>\n\t\t\t\t%s\n\t\t\t\t%s\n\t\t\t</node>\n", id, cstr.getName(), "", "<viz:color r=\"63\" g=\"127\" b=\"191\" a=\"0.1\"/>", "<viz:shape value=\"square\"/>"));
            for (Propagator prop : cstr.getPropagators()) {
                for (Variable var : prop.getVars()) {
                    if (tIntHashSet.contains(var.getId())) continue;
                    tIntHashSet.add(var.getId());
                    edges.append(String.format("\t\t\t<edge id=\"%s\" source=\"%s\" target=\"%s\" type=\"directed\"/>\n", edgeCount++, id, var.getId()));
                }
            }
        }
        try {
            Files.createFile(file, new FileAttribute[0]);
            Files.write(file, "<?xml version=\"1.0\" encoding=\"UTF\u22128\"?>\n<gexf \txmlns=\"http://www.gexf.net/1.2draft\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema\u2212instance\"\n\txsi:schemaLocation=\"http://www.gexf.net/1.2draft\n\t\thttp://www.gexf.net/1.2draft/gexf.xsd\"\n\txmlns:viz=\"http://www.gexf.net/1.2draft/viz\"\n\tversion=\"1.2\">\n".getBytes(), StandardOpenOption.WRITE);
            Files.write(file, "\t<graph mode=\"static\" defaultedgetype=\"directed\">\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, String.format("\t\t<nodes count=\"%d\">\n", nodeCount).getBytes(), StandardOpenOption.APPEND);
            Files.write(file, nodes.toString().getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t\t</nodes>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t\t<edges>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, edges.toString().getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t\t</edges>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t</graph>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "</gexf>\n".getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Unable to write to GEXF file. No information will be sent.");
        }
    }
}

