/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import java.util.Collections;
import java.util.List;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class MoveLNS
implements Move {
    protected Move move;
    protected INeighbor neighbor;
    protected long solutions;
    protected boolean solutionLoaded;
    private boolean freshRestart;
    protected ICounter counter;
    private final long frequency;
    protected PropLNS prop;
    private boolean canApplyNeighborhood;

    public MoveLNS(Move move, INeighbor neighbor, ICounter restartCounter) {
        this.move = move;
        this.neighbor = neighbor;
        this.counter = restartCounter;
        this.frequency = this.counter.getLimitValue();
        this.solutions = 0L;
        this.freshRestart = false;
        this.solutionLoaded = false;
    }

    @Override
    public boolean init() {
        this.neighbor.init();
        return this.move.init();
    }

    @Override
    public boolean extend(Solver solver) {
        boolean extend;
        if (this.solutions > 0L || this.solutionLoaded) {
            if (this.freshRestart) {
                assert (solver.getDecisionPath().size() == 1);
                assert (solver.getDecisionPath().getDecision(0) == RootDecision.ROOT);
                solver.getEnvironment().worldPush();
                if (this.prop == null) {
                    this.prop = new PropLNS(solver.getModel().intVar(2));
                    new Constraint("LNS", this.prop).post();
                }
                solver.getEngine().propagateOnBacktrack(this.prop);
                this.canApplyNeighborhood = true;
                this.freshRestart = false;
                extend = true;
            } else if (this.counter.isMet()) {
                this.doRestart(solver);
                extend = true;
            } else {
                extend = this.move.extend(solver);
            }
        } else {
            extend = this.move.extend(solver);
        }
        return extend;
    }

    @Override
    public boolean repair(Solver solver) {
        boolean repair = true;
        if (this.solutions > 0L || solver.getSolutionCount() > 0L || this.solutionLoaded) {
            if (this.solutions < solver.getSolutionCount()) {
                assert (this.solutions == solver.getSolutionCount() - 1L);
                ++this.solutions;
                this.solutionLoaded = false;
                this.neighbor.recordSolution();
                this.doRestart(solver);
            } else if (this.freshRestart) {
                repair = false;
            } else {
                repair = this.move.repair(solver);
                if (!repair) {
                    if (!this.neighbor.isSearchComplete()) {
                        this.doRestart(solver);
                        repair = true;
                    }
                } else if (this.counter.isMet()) {
                    this.doRestart(solver);
                }
            }
        } else {
            repair = this.move.repair(solver);
        }
        return repair;
    }

    public void loadFromSolution(Solution solution, Solver solver) {
        this.neighbor.loadFromSolution(solution);
        this.solutionLoaded = true;
        if (this.solutions == 0L) {
            this.freshRestart = true;
        } else {
            this.doRestart(solver);
        }
    }

    @Override
    public void setTopDecisionPosition(int position) {
        this.move.setTopDecisionPosition(position);
    }

    @Override
    public <V extends Variable> AbstractStrategy<V> getStrategy() {
        return this.move.getStrategy();
    }

    @Override
    public <V extends Variable> void setStrategy(AbstractStrategy<V> aStrategy) {
        this.move.setStrategy(aStrategy);
    }

    @Override
    public void removeStrategy() {
        this.move.removeStrategy();
    }

    private void doRestart(Solver solver) {
        if (!this.freshRestart) {
            this.neighbor.restrictLess();
        }
        this.freshRestart = true;
        this.counter.overrideLimit(this.counter.currentValue() + this.frequency);
        solver.restart();
    }

    @Override
    public List<Move> getChildMoves() {
        return Collections.singletonList(this.move);
    }

    @Override
    public void setChildMoves(List<Move> someMoves) {
        if (someMoves.size() != 1) {
            throw new UnsupportedOperationException("Only one child move can be attached to it.");
        }
        this.move = someMoves.get(0);
    }

    class PropLNS
    extends Propagator<IntVar> {
        PropLNS(IntVar var) {
            super((Variable[])new IntVar[]{var});
            this.vars = new IntVar[0];
        }

        @Override
        public int getPropagationConditions(int vIdx) {
            return IntEventType.VOID.getMask();
        }

        @Override
        public void propagate(int evtmask) throws ContradictionException {
            if (MoveLNS.this.canApplyNeighborhood) {
                MoveLNS.this.canApplyNeighborhood = false;
                MoveLNS.this.neighbor.fixSomeVariables();
            }
        }

        @Override
        public ESat isEntailed() {
            return ESat.TRUE;
        }

        @Override
        public void explain(int p, ExplanationForSignedClause explanation) {
            IntVar pivot = explanation.readVar(p);
            IntIterableRangeSet dom = explanation.complement(pivot);
            IntIterableSetUtils.unionOf(dom, explanation.readDom(p));
            pivot.intersectLit(dom, explanation);
        }
    }
}

