/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.MathUtils;

@Explained(partial=true, comment="must be tested")
public final class PropGreaterOrEqualXY_C
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final int cste;

    public PropGreaterOrEqualXY_C(IntVar[] vars, int c) {
        super((Variable[])vars, (Priority)PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
        this.cste = c;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.INSTANTIATE.getMask() + IntEventType.DECUPP.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x.updateLowerBound(MathUtils.safeSubstract(this.cste, this.y.getUB()), this, this.lcg() ? Reason.r(this.y.getMaxLit()) : Reason.undef());
        this.y.updateLowerBound(MathUtils.safeSubstract(this.cste, this.x.getUB()), this, this.lcg() ? Reason.r(this.x.getMaxLit()) : Reason.undef());
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.y.updateLowerBound(this.cste - this.x.getUB(), this, this.lcg() ? Reason.r(this.x.getMaxLit()) : Reason.undef());
        } else {
            this.x.updateLowerBound(this.cste - this.y.getUB(), this, this.lcg() ? Reason.r(this.y.getMaxLit()) : Reason.undef());
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() + this.y.getUB() < this.cste) {
            return ESat.FALSE;
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.x.getName() + " + " + this.y.getName() + " >= " + this.cste;
    }
}

