/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.restart.AbstractRestart;
import org.chocosolver.solver.search.restart.GeometricalCutoff;
import org.chocosolver.solver.search.restart.Restarter;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.SearchParams;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMin;
import org.chocosolver.solver.search.strategy.selectors.variables.Cyclic;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.VariableUtils;

public class BlackBoxConfigurator {
    Function<IntVar[], AbstractStrategy<IntVar>> intVarStrategy;
    BiFunction<IntVar, Boolean, AbstractStrategy<IntVar>> intObjVarStrategy;
    Function<SetVar[], AbstractStrategy<SetVar>> setVarStrategy;
    Function<GraphVar<?>[], AbstractStrategy<GraphVar<?>>> graphVarSearch;
    Function<RealVar[], AbstractStrategy<RealVar>> realVarStrategy;
    BiFunction<RealVar, Boolean, AbstractStrategy<RealVar>> realObjVarStrategy;
    Function<AbstractStrategy<?>, AbstractStrategy<?>> metaStrategy;
    Function<Solver, AbstractRestart> restartPolicy;
    boolean nogoodOnRestart;
    boolean generatePartialAssignment;
    boolean restartOnSolution;
    boolean excludeViews;
    boolean excludeObjective;

    private BlackBoxConfigurator() {
    }

    public static BlackBoxConfigurator init() {
        return new BlackBoxConfigurator().setIntVarStrategy(Search::intVarSearch).setIntObjVarStrategy((obj, max) -> max != false ? Search.minDomUBSearch(obj) : Search.minDomLBSearch(obj)).setSetVarStrategy(Search::setVarSearch).setGraphVarSearch(Search::graphVarSearch).setRealVarStrategy(Search::realVarSearch).setRealObjVarStrategy((obj, max) -> Search.realVarSearch(new Cyclic<RealVar>(), max != false ? new RealDomainMax() : new RealDomainMin(), max == false, obj)).setMetaStrategy(Search::lastConflict).setRestartPolicy(solver -> AbstractRestart.NO_RESTART).setRestartOnSolution(false).setNogoodOnRestart(false).setExcludeViews(false).setExcludeObjective(true);
    }

    public static BlackBoxConfigurator prepare(Model model) {
        if (model.getSolver().getObjectiveManager().getPolicy() == ResolutionPolicy.SATISFACTION) {
            return BlackBoxConfigurator.forCSP();
        }
        return BlackBoxConfigurator.forCOP();
    }

    public static BlackBoxConfigurator forCSP() {
        BlackBoxConfigurator bb = BlackBoxConfigurator.init();
        SearchParams.ValSelConf defaultValSel = new SearchParams.ValSelConf(SearchParams.ValueSelection.MIN, false, 16, true);
        SearchParams.VarSelConf defaultVarSel = new SearchParams.VarSelConf(SearchParams.VariableSelection.DOMWDEG_CACD, 32);
        bb.setIntVarStrategy(vars -> defaultVarSel.make().apply((IntVar[])vars, defaultValSel.make().apply(vars[0].getModel())));
        bb.setRestartPolicy(s -> new Restarter(new GeometricalCutoff(5L, 1.05), c -> s.getFailCount() >= c, 50000, true));
        bb.setNogoodOnRestart(true).setRestartOnSolution(false).setExcludeObjective(true).setExcludeViews(false).setMetaStrategy(m -> Search.lastConflict(m, 4));
        return bb;
    }

    public static BlackBoxConfigurator forCOP() {
        BlackBoxConfigurator bb = BlackBoxConfigurator.init();
        SearchParams.ValSelConf defaultValSel = new SearchParams.ValSelConf(SearchParams.ValueSelection.MIN, true, 16, true);
        SearchParams.VarSelConf defaultVarSel = new SearchParams.VarSelConf(SearchParams.VariableSelection.DOMWDEG, 32);
        bb.setIntVarStrategy(vars -> defaultVarSel.make().apply((IntVar[])vars, defaultValSel.make().apply(vars[0].getModel())));
        SearchParams.ResConf defaultResConf = new SearchParams.ResConf(SearchParams.Restart.GEOMETRIC, 10, 1.05, 50000, true);
        bb.setRestartPolicy(defaultResConf.make());
        bb.setNogoodOnRestart(true).setRestartOnSolution(true).setExcludeObjective(true).setExcludeViews(false).setMetaStrategy(m -> Search.lastConflict(m, 1));
        return bb;
    }

    public void make(Model model) {
        this.complete(model, null);
    }

    public void complete(Model model, AbstractStrategy<Variable> declaredStrategy) {
        Solver solver = model.getSolver();
        ArrayList<IntVar> livars = new ArrayList<IntVar>();
        ArrayList<SetVar> lsvars = new ArrayList<SetVar>();
        ArrayList<GraphVar> lgvars = new ArrayList<GraphVar>();
        ArrayList<RealVar> lrvars = new ArrayList<RealVar>();
        Variable[] variables = model.getVars();
        Variable objective = null;
        block6: for (Variable var : variables) {
            if (VariableUtils.isConstant(var) || VariableUtils.isView(var) && this.excludeViews) continue;
            int type = var.getTypeAndKind();
            int kind = type & 0x3F8;
            switch (kind) {
                case 8: 
                case 24: {
                    livars.add((IntVar)var);
                    continue block6;
                }
                case 32: {
                    lsvars.add((SetVar)var);
                    continue block6;
                }
                case 128: {
                    lgvars.add((GraphVar)var);
                    continue block6;
                }
                case 64: {
                    lrvars.add((RealVar)var);
                    continue block6;
                }
            }
        }
        if (solver.getObjectiveManager().isOptimization() && this.excludeObjective) {
            objective = (Variable)solver.getObjectiveManager().getObjective();
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                lrvars.remove(objective);
            } else {
                assert ((objective.getTypeAndKind() & 8) != 0);
                livars.remove(objective);
            }
        }
        ArrayList<AbstractStrategy<Variable>> strats = new ArrayList<AbstractStrategy<Variable>>();
        if (declaredStrategy != null) {
            strats.add(declaredStrategy);
        }
        if (livars.size() > 0) {
            strats.add(this.intVarStrategy.apply(livars.toArray(new IntVar[0])));
        }
        if (lsvars.size() > 0) {
            strats.add(this.setVarStrategy.apply(lsvars.toArray(new SetVar[0])));
        }
        if (lgvars.size() > 0) {
            strats.add(this.graphVarSearch.apply(lgvars.toArray(new GraphVar[0])));
        }
        if (lrvars.size() > 0) {
            strats.add(this.realVarStrategy.apply(lrvars.toArray(new RealVar[0])));
        }
        if (objective != null) {
            boolean max;
            boolean bl = max = solver.getObjectiveManager().getPolicy() == ResolutionPolicy.MAXIMIZE;
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                strats.add(this.realObjVarStrategy.apply((RealVar)objective, max));
            } else {
                strats.add(this.intObjVarStrategy.apply((IntVar)objective, max));
            }
        }
        if (strats.isEmpty()) {
            strats.add(Search.minDomLBSearch(model.boolVar(true)));
        }
        AbstractStrategy main = Search.sequencer(strats.toArray(new AbstractStrategy[0]));
        solver.addRestarter(this.restartPolicy.apply(solver));
        if (this.nogoodOnRestart) {
            solver.setNoGoodRecordingFromRestarts();
        }
        AbstractStrategy<?> strat = this.metaStrategy.apply(main);
        if (this.generatePartialAssignment) {
            strat = Search.generatePartialAssignment(livars.toArray(new IntVar[0]), 20, false, strat);
        }
        solver.setSearch(strat);
    }

    public BlackBoxConfigurator setIntVarStrategy(Function<IntVar[], AbstractStrategy<IntVar>> intVarStrategy) {
        this.intVarStrategy = intVarStrategy;
        return this;
    }

    public BlackBoxConfigurator setIntObjVarStrategy(BiFunction<IntVar, Boolean, AbstractStrategy<IntVar>> intObjVarStrategy) {
        this.intObjVarStrategy = intObjVarStrategy;
        return this;
    }

    public BlackBoxConfigurator setSetVarStrategy(Function<SetVar[], AbstractStrategy<SetVar>> setVarStrategy) {
        this.setVarStrategy = setVarStrategy;
        return this;
    }

    public BlackBoxConfigurator setGraphVarSearch(Function<GraphVar<?>[], AbstractStrategy<GraphVar<?>>> graphVarSearch) {
        this.graphVarSearch = graphVarSearch;
        return this;
    }

    public BlackBoxConfigurator setRealVarStrategy(Function<RealVar[], AbstractStrategy<RealVar>> realVarStrategy) {
        this.realVarStrategy = realVarStrategy;
        return this;
    }

    public BlackBoxConfigurator setRealObjVarStrategy(BiFunction<RealVar, Boolean, AbstractStrategy<RealVar>> realObjVarStrategy) {
        this.realObjVarStrategy = realObjVarStrategy;
        return this;
    }

    public BlackBoxConfigurator setMetaStrategy(Function<AbstractStrategy<?>, AbstractStrategy<?>> metaStrategy) {
        this.metaStrategy = metaStrategy;
        return this;
    }

    public BlackBoxConfigurator setRestartPolicy(SearchParams.Restart pol, int cutoff, double geo, int offset, boolean resetOnSolution) {
        SearchParams.ResConf conf = new SearchParams.ResConf(pol, cutoff, geo, offset, resetOnSolution);
        this.restartPolicy = conf.make();
        return this;
    }

    public BlackBoxConfigurator setRestartPolicy(Function<Solver, AbstractRestart> restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public BlackBoxConfigurator setNogoodOnRestart(boolean nogoodOnRestart) {
        this.nogoodOnRestart = nogoodOnRestart;
        return this;
    }

    public BlackBoxConfigurator setRestartOnSolution(boolean restartOnSolution) {
        this.restartOnSolution = restartOnSolution;
        return this;
    }

    public void setRefinedPartialAssignmentGeneration(boolean rgpa) {
        this.generatePartialAssignment = rgpa;
    }

    public BlackBoxConfigurator setExcludeViews(boolean excludeViews) {
        this.excludeViews = excludeViews;
        return this;
    }

    public BlackBoxConfigurator setExcludeObjective(boolean excludeObjective) {
        this.excludeObjective = excludeObjective;
        return this;
    }

    public String toString() {
        return "BlackBoxConfigurator{intVarStrategy=" + this.intVarStrategy + ", intObjVarStrategy=" + this.intObjVarStrategy + ", setVarStrategy=" + this.setVarStrategy + ", graphVarSearch=" + this.graphVarSearch + ", realVarStrategy=" + this.realVarStrategy + ", realObjVarStrategy=" + this.realObjVarStrategy + ", metaStrategy=" + this.metaStrategy + ", restartPolicy=" + this.restartPolicy + ", nogoodOnRestart=" + this.nogoodOnRestart + ", restartOnSolution=" + this.restartOnSolution + ", rgpa=" + this.generatePartialAssignment + ", excludeViews=" + this.excludeViews + ", excludeObjective=" + this.excludeObjective + '}';
    }
}

