/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.objective.ObjectiveStrategy;
import org.chocosolver.solver.objective.OptimizationPolicy;
import org.chocosolver.solver.search.strategy.BlackBoxConfigurator;
import org.chocosolver.solver.search.strategy.BoundSearch;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.IbexDecision;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainBest;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainLast;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandom;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandomBound;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.values.RealValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.SetDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.SetValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphLexEdge;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphRandomEdge;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphLexNode;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphNodeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphRandomNode;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeOrEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeThenEdges;
import org.chocosolver.solver.search.strategy.selectors.variables.ActivityBased;
import org.chocosolver.solver.search.strategy.selectors.variables.ConflictHistorySearch;
import org.chocosolver.solver.search.strategy.selectors.variables.Cyclic;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDeg;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDegRef;
import org.chocosolver.solver.search.strategy.selectors.variables.FailureBased;
import org.chocosolver.solver.search.strategy.selectors.variables.FirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.GeneralizedMinDomVarSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.InputOrder;
import org.chocosolver.solver.search.strategy.selectors.variables.PickOnDom;
import org.chocosolver.solver.search.strategy.selectors.variables.PickOnFil;
import org.chocosolver.solver.search.strategy.selectors.variables.Random;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.ConflictOrderingSearch;
import org.chocosolver.solver.search.strategy.strategy.GraphStrategy;
import org.chocosolver.solver.search.strategy.strategy.GreedyBranching;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.LastConflict;
import org.chocosolver.solver.search.strategy.strategy.PartialAssignmentGenerator;
import org.chocosolver.solver.search.strategy.strategy.RealStrategy;
import org.chocosolver.solver.search.strategy.strategy.RoundRobin;
import org.chocosolver.solver.search.strategy.strategy.SetStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class Search {
    public static <V extends Variable> AbstractStrategy<V> lastConflict(AbstractStrategy<V> formerSearch) {
        return Search.lastConflict(formerSearch, 1);
    }

    public static AbstractStrategy<IntVar> bestBound(AbstractStrategy<IntVar> formerSearch) {
        if (formerSearch == null) {
            throw new UnsupportedOperationException("the search strategy in parameter cannot be null! Consider using Search.defaultSearch(model)");
        }
        return new BoundSearch(formerSearch);
    }

    public static <V extends Variable> AbstractStrategy<V> lastConflict(AbstractStrategy<V> formerSearch, int k) {
        if (formerSearch == null) {
            throw new UnsupportedOperationException("the search strategy in parameter cannot be null! Consider using Search.defaultSearch(model)");
        }
        return new LastConflict<V>(formerSearch.getVariables()[0].getModel(), formerSearch, k);
    }

    public static <V extends Variable> AbstractStrategy<V> conflictOrderingSearch(AbstractStrategy<V> formerSearch) {
        return new ConflictOrderingSearch<V>(formerSearch.getVariables()[0].getModel(), formerSearch);
    }

    public static AbstractStrategy<?> generatePartialAssignment(IntVar[] ivars, int maxSolNum, boolean largerCutoff, AbstractStrategy<?> formerSearch) {
        return new PartialAssignmentGenerator(ivars, maxSolNum, largerCutoff, formerSearch);
    }

    public static AbstractStrategy<?> greedySearch(AbstractStrategy<?> search) {
        return new GreedyBranching(search);
    }

    public static AbstractStrategy sequencer(AbstractStrategy ... searches) {
        if (searches == null || searches.length == 0) {
            throw new IllegalArgumentException("The array of strategies cannot be null or empty");
        }
        return new StrategiesSequencer(searches);
    }

    public static SetStrategy setVarSearch(VariableSelector<SetVar> varS, SetValueSelector valS, boolean enforceFirst, SetVar ... sets) {
        if (sets == null || sets.length == 0) {
            throw new IllegalArgumentException("The array of variables cannot be null or empty");
        }
        return new SetStrategy(sets, varS, valS, enforceFirst);
    }

    public static SetStrategy setVarSearch(SetVar ... sets) {
        return Search.setVarSearch(new GeneralizedMinDomVarSelector<SetVar>(), new SetDomainMin(), true, sets);
    }

    public static AbstractStrategy<SetVar> domOverWDegSearch(SetVar ... vars) {
        return Search.setVarSearch(new DomOverWDeg((Variable[])vars, 0L), new SetDomainMin(), true, vars);
    }

    public static AbstractStrategy<SetVar> domOverWDegRefSearch(SetVar ... vars) {
        return Search.setVarSearch(new DomOverWDegRef((Variable[])vars, 0L), new SetDomainMin(), true, vars);
    }

    public static AbstractStrategy<SetVar> conflictHistorySearch(SetVar ... vars) {
        return Search.setVarSearch(new ConflictHistorySearch((Variable[])vars, 0L), new SetDomainMin(), true, vars);
    }

    public static AbstractStrategy<SetVar> failureRateBasedSearch(SetVar ... vars) {
        return Search.setVarSearch(new FailureBased((Variable[])vars, 0L, 2), new SetDomainMin(), true, vars);
    }

    public static AbstractStrategy<SetVar> failureLengthBasedSearch(SetVar ... vars) {
        return Search.setVarSearch(new FailureBased((Variable[])vars, 0L, 4), new SetDomainMin(), true, vars);
    }

    public static GraphStrategy graphVarSearch(VariableSelector<GraphVar> varS, GraphNodeOrEdgeSelector nodeOrEdgeS, GraphNodeSelector nodeS, GraphEdgeSelector edgeS, boolean enforceFirst, GraphVar ... graphs) {
        if (graphs == null || graphs.length == 0) {
            throw new IllegalArgumentException("The set of variables cannot be null or empty");
        }
        return new GraphStrategy(graphs, varS, nodeOrEdgeS, nodeS, edgeS, enforceFirst);
    }

    public static GraphStrategy graphVarSearch(GraphVar ... graphs) {
        return Search.graphVarSearch(new InputOrder<GraphVar>(graphs[0].getModel()), new GraphNodeThenEdges(), new GraphLexNode(), new GraphLexEdge(), true, graphs);
    }

    public static GraphStrategy randomGraphVarSearch(long seed, GraphVar ... graphs) {
        return Search.graphVarSearch(new Random<GraphVar>(seed), new GraphNodeThenEdges(), new GraphRandomNode(seed), new GraphRandomEdge(seed), true, graphs);
    }

    public static RealStrategy realVarSearch(VariableSelector<RealVar> varS, RealValueSelector valS, double epsilon, boolean leftFirst, RealVar ... rvars) {
        if (rvars == null || rvars.length == 0) {
            throw new IllegalArgumentException("The array of variables cannot be null or empty");
        }
        return new RealStrategy(rvars, varS, valS, epsilon, leftFirst);
    }

    public static RealStrategy realVarSearch(double epsilon, RealVar ... reals) {
        return Search.realVarSearch(new Cyclic<RealVar>(), (RealValueSelector)new RealDomainMiddle(), epsilon, true, reals);
    }

    public static RealStrategy realVarSearch(VariableSelector<RealVar> varS, RealValueSelector valS, boolean leftFirst, RealVar ... rvars) {
        return Search.realVarSearch(varS, valS, Double.NaN, leftFirst, rvars);
    }

    public static RealStrategy realVarSearch(RealVar ... reals) {
        return Search.realVarSearch(new Cyclic<RealVar>(), (RealValueSelector)new RealDomainMiddle(), true, reals);
    }

    public static IntStrategy intVarSearch(VariableSelector<IntVar> varSelector, IntValueSelector valSelector, DecisionOperator<IntVar> decisionOperator, IntVar ... vars) {
        if (vars == null || vars.length == 0) {
            throw new IllegalArgumentException("The array of variables cannot be null or empty");
        }
        return new IntStrategy(vars, varSelector, valSelector, decisionOperator);
    }

    public static IntStrategy intVarSearch(VariableSelector<IntVar> varSelector, IntValueSelector valSelector, IntVar ... vars) {
        return Search.intVarSearch(varSelector, valSelector, DecisionOperatorFactory.makeIntEq(), vars);
    }

    public static AbstractStrategy<IntVar> intVarSearch(IntVar ... vars) {
        IntValueSelector valueSelector;
        Model model = vars[0].getModel();
        if (model.getResolutionPolicy() == ResolutionPolicy.SATISFACTION || !(model.getObjective() instanceof IntVar)) {
            valueSelector = new IntDomainMin();
        } else {
            Solution solution;
            valueSelector = new IntDomainBest();
            if (model.getSolver().defaultSolutionExists()) {
                solution = model.getSolver().defaultSolution();
            } else {
                solution = new Solution(model, vars);
                model.getSolver().attach(solution);
            }
            valueSelector = new IntDomainLast(solution, valueSelector, null);
        }
        return Search.intVarSearch((VariableSelector<IntVar>)new DomOverWDeg((Variable[])vars, 0L), valueSelector, vars);
    }

    public static AbstractStrategy<IntVar> domOverWDegSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new DomOverWDeg((Variable[])vars, 0L), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static AbstractStrategy<IntVar> domOverWDegRefSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new DomOverWDegRef((Variable[])vars, 0L), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static AbstractStrategy<IntVar> activityBasedSearch(IntVar ... vars) {
        if (vars == null || vars.length == 0) {
            throw new IllegalArgumentException("The array of variables cannot be null or empty");
        }
        return new ActivityBased(vars);
    }

    public static AbstractStrategy<IntVar> conflictHistorySearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new ConflictHistorySearch((Variable[])vars, 0L), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static AbstractStrategy<IntVar> failureRateBasedSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FailureBased((Variable[])vars, 0L, 2), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static AbstractStrategy<IntVar> failureLengthBasedSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FailureBased((Variable[])vars, 0L, 4), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static AbstractStrategy<IntVar> pickOnDom(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new PickOnDom((Variable[])vars), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static AbstractStrategy<IntVar> pickOnFil(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new PickOnFil((Variable[])vars), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static IntStrategy randomSearch(IntVar[] vars, long seed) {
        IntDomainRandom value = new IntDomainRandom(seed);
        IntDomainRandomBound bound = new IntDomainRandomBound(seed);
        IntValueSelector selector = var -> {
            if (var.hasEnumeratedDomain()) {
                return value.selectValue(var);
            }
            return bound.selectValue(var);
        };
        return Search.intVarSearch(new Random<IntVar>(seed), selector, vars);
    }

    public static AbstractStrategy<IntVar> objectiveStrategy(IntVar objective, OptimizationPolicy optPolicy) {
        return new ObjectiveStrategy(objective, optPolicy);
    }

    public static AbstractStrategy<IntVar> roundRobinSearch(IntVar ... vars) {
        long seed = 1000000007L;
        return new RoundRobin(vars, new VariableSelector[]{new DomOverWDegRef((Variable[])vars, seed), new DomOverWDeg((Variable[])vars, seed), new PickOnDom((Variable[])vars, 2, 32), new FailureBased((Variable[])vars, seed, 4)}, new IntValueSelector[]{new IntDomainMin(), new IntDomainMax(), new IntDomainRandom(seed)}, true, false);
    }

    public static IntStrategy inputOrderLBSearch(IntVar ... vars) {
        return Search.intVarSearch(new InputOrder<IntVar>(vars[0].getModel()), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static IntStrategy inputOrderUBSearch(IntVar ... vars) {
        return Search.intVarSearch(new InputOrder<IntVar>(vars[0].getModel()), (IntValueSelector)new IntDomainMax(), vars);
    }

    public static IntStrategy minDomLBSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(vars[0].getModel()), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static IntStrategy minDomUBSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(vars[0].getModel()), (IntValueSelector)new IntDomainMax(), vars);
    }

    public static void defaultSearch(Model model) {
        BlackBoxConfigurator.init().make(model);
    }

    public static AbstractStrategy<Variable> ibexSolving(final Model model) {
        return new AbstractStrategy(model.getVars()){
            final IbexDecision dec;
            {
                super(variables);
                this.dec = new IbexDecision(model);
            }

            public Decision<Variable> getDecision() {
                if (this.dec.inUse()) {
                    return null;
                }
                return this.dec;
            }
        };
    }
}

