% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terra_utils.R
\name{cell_width}
\alias{cell_width}
\title{Compute the width of a cell}
\usage{
cell_width(raster_layer, unit = "m")
}
\arguments{
\item{raster_layer}{\code{\link[terra:rast]{terra::rast()}} Raster object.}

\item{unit}{\code{unit} object or a \code{character} that can be coerced to a unit
(see \code{unit} package). Must be an length unit.}
}
\value{
\code{numeric} The width of a cell in the desired unit.
}
\description{
Compute the width of a cell
}
\details{
The input raster must have a projected coordinate system. The distortion is
not corrected. It could be using the \code{cellSize} function of the \code{terra}
package, but this function is currently pretty slow for large rasters. If
your problem is at regional scale, the distortion should be negligible.
However, at larger scales, the best is to use an equal-area projected
coordinate system.
}
\examples{
\dontrun{
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)
cell_width(habitat_data, "m")
}

}
