% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_no_objective.R
\name{set_no_objective}
\alias{set_no_objective}
\title{Configure the solver to only satisfy the constraints, without optimization
objective}
\usage{
set_no_objective(problem)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Specify that a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) should satisfy
the constraints without optimization objective.
}
\details{
Using set_no_objective() in a restopt problem, the solver will
return the first solution found satisfying the constraint, without any
optimization objective. This "no objective" setting is set by default
when creating a restopt problem.
}
\examples{
\dontrun{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\% set_no_objective()

# print problem
print(p)

# Solve problem
s <- solve(p)
# plot solution
plot(s)
}

}
\seealso{
Other objectives: 
\code{\link{set_max_iic_objective}()},
\code{\link{set_max_mesh_objective}()},
\code{\link{set_max_nb_pus_objective}()},
\code{\link{set_max_restore_objective}()},
\code{\link{set_min_nb_patches_objective}()},
\code{\link{set_min_nb_pus_objective}()},
\code{\link{set_min_restore_objective}()}
}
\concept{objectives}
