% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SturmHabicht.R
\name{SturmHabicht}
\alias{SturmHabicht}
\title{Sturm-Habicht sequence of a polynomial}
\usage{
SturmHabicht(qspray, var = 1)
}
\arguments{
\item{qspray}{a \code{qspray} polynomial having at most nine variables}

\item{var}{index of the variable with respect to which the Sturm-Habicht
sequence will be computed}
}
\value{
A list of \code{qspray} polynomials, the Sturm-Habicht sequence of
  \code{qspray}, starting with the \code{0}-th Sturm-Habicht polynomial.
}
\description{
Sturm-Habicht sequence of a polynomial with rational
  coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
SturmHabicht(x^3*y^2 + 2*x*y + 1)
}
