% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numberOfRealRoots.R
\name{numberOfRealRootsInInterval}
\alias{numberOfRealRootsInInterval}
\title{Number of real roots in an interval}
\usage{
numberOfRealRootsInInterval(qspray, lower, upper, closed = TRUE)
}
\arguments{
\item{qspray}{a univariate \code{qspray} polynomial}

\item{lower, upper}{the bounds of the interval, \code{bigq} numbers or
objects coercible to \code{bigq} numbers, and it is also possible to set
\code{lower = -Inf} and \code{upper = Inf}}

\item{closed}{Boolean, whether to consider the interval is closed or open}
}
\value{
An integer, the number of real roots of the polynomial in the
  interval.
}
\description{
Number of distinct real roots of a univariate polynomial in
  a given interval.
}
\note{
The roots are not counted with their multiplicity.
}
\examples{
library(resultant)
x <- qlone(1)
P <- 2*x^4 + x^3 - 3*x^2 - x + 1
numberOfRealRootsInInterval(P, 0, 1)
}
