% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-python.R
\name{install_python}
\alias{install_python}
\title{Install Python}
\usage{
install_python(version = "3.9:latest", list = FALSE, force = FALSE)
}
\arguments{
\item{version}{The version of Python to install.}

\item{list}{Boolean; if set, list the set of available Python versions?}

\item{force}{Boolean; force re-installation even if the requested version
of Python is already installed?}
}
\description{
Download and install Python, using the \href{https://github.com/pyenv/pyenv}{pyenv}.
and \href{https://github.com/pyenv-win/pyenv-win}{pyenv-win} projects.
}
\details{
In general, it is recommended that Python virtual environments are created
using the copies of Python installed by \code{\link[=install_python]{install_python()}}. For example:\preformatted{library(reticulate)
version <- "3.9.12"
install_python(version)
virtualenv_create("my-environment", version = version)
use_virtualenv("my-environment")

# There is also support for a ":latest" suffix to select the latest patch release
install_python("3.9:latest") # install latest patch available at python.org

# select the latest 3.9.* patch installed locally
virtualenv_create("my-environment", version = "3.9:latest")
}
}
\note{
On macOS and Linux this will build Python from sources, which may take a few minutes.
}
