% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTeamIDs.R
\name{getTeamIDs}
\alias{getTeamIDs}
\title{Retrieve team IDs for event files}
\usage{
getTeamIDs(year)
}
\arguments{
\item{year}{A single valid four-digit numeric year.}
}
\value{
If the file exists, a named vector of IDs for the given year.
Otherwise \code{NA}.
}
\description{
This function retrieves the team ID needed for the
\code{team} argument of \code{getRetrosheet("play", year, team)}.
}
\details{
All currently available years can be retrieved with
\code{type.convert(substr(getFileNames()$event, 1L, 4L))}
}
\examples{
\donttest{
getTeamIDs(2010)
}

}
