% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_users.R
\name{get_users}
\alias{get_users}
\title{Get Users by Product ID, Type, and Various Date Spans}
\usage{
get_users(
  rev_product_ids,
  user_type,
  rev_date_type,
  rev_start_date,
  rev_end_date,
  rev_session_id,
  rev_username,
  lost_days = 30,
  lost_reported = "dateLastSeen",
  optional_json = ""
)
}
\arguments{
\item{rev_product_ids}{A vector of Revenera product id's for which
you want active user data.}

\item{user_type}{One of "active," "new", or "lost."}

\item{rev_date_type}{Level of aggregation, Revenera will accept
"day", "week", or "month".}

\item{rev_start_date}{Date formatted YYYY-MM-DD. Revenera may give
an error if you try to go back too far.}

\item{rev_end_date}{Date formatted YYYY-MM-DD.}

\item{rev_session_id}{Session ID established by the connection to
Revenera API. This can be obtained with revenera_auth().}

\item{rev_username}{Revenera username.}

\item{lost_days}{Required for lost users, the number of consecutive
days of inactivity before a client is considered lost.}

\item{lost_reported}{Required for lost users, should the lost date
be the first day of inactivity ("dateLastSeen") or date 
client is considered lost ("dateDeclaredLost").}

\item{optional_json}{Optional JSON text to add to the request body 
for things like global filters.}
}
\value{
Data frame with active users for each product id and
unique date within the range
}
\description{
For a given period of time (a day, week, or month) Revenera's API
summarizes and returns the number of active users. With this function
you can return daily, weekly, or monthly active users for multiple 
product ids.
}
\details{
You can specify a start and end date but Revenera does not store
an indefinite period of historical data. 

It is not recommended that your username be stored directly in your
code. There are various methods and packages available that are more 
secure; this package does not require you to use any one in particular.

The optional_json parameter is available so that other optional arguments
can be added to the api request. This will require the user to consult
the API documentation. See README for an example.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
product_ids_list <- c("123", "456", "789")
start_date <- lubridate::floor_date(Sys.Date(), unit = "months") - months(6)
end_date <- Sys.Date() - 1
session_id <- revenera_auth(rev_user, rev_pwd)
global_filter <- paste0(",\"globalFilters\":{\"licenseType\":",
"{\"type\":\"string\",\"value\":\"purchased\"}}")
monthly_active_users <- get_users(product_ids_list,
"active",
"month",
start_date,
end_date,
session_id,
rev_user,
optional_json = global_filter)
}
}
