% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_daily_client_properties.R
\name{get_daily_client_properties}
\alias{get_daily_client_properties}
\title{Get Daily Property Values for All Clients for a List of Product Ids}
\usage{
get_daily_client_properties(
  rev_product_ids,
  product_properties_df,
  desired_properties,
  installed_start_date,
  installed_end_date,
  daily_start_date,
  daily_end_date,
  chatty = FALSE
)
}
\arguments{
\item{rev_product_ids}{A vector of Revenera product id.}

\item{product_properties_df}{Data frame with available properties
for all product ids. Can obtain with the get_product_properties function.}

\item{desired_properties}{The property names of the metadata you want
to collect.}

\item{installed_start_date}{Date object for the starting date of
product installations.}

\item{installed_end_date}{Date object for the ending date of
product installations.}

\item{daily_start_date}{Date object for the starting date of desired
properties of the product.}

\item{daily_end_date}{Date object for the ending date of desired
properties of the product.}

\item{chatty}{The function can be chatty, sending a message to the console
for every iteration through a product Id. Many API calls may be required
and the console may get very long and it may slow down the execution.}
}
\value{
Data frame with first date a property value appears until it changed
for each Client Id.
}
\description{
Returns the list of daily client properties for all the client Ids
installed during a user provided date range for all the Product Ids. In
order to decrease how much is returned only the first date for a property
value is returned. For example, if Property A had value 1 for 3 days, then
value 2 for 2 days, then value 1 again on day 6, it will return the day 1
value of 1, day 4 value of 2, and day 6 value of 1.
}
\details{
It is not recommended that your username be stored directly in your
code. There are various methods and packages available that are more
secure; this package does not require you to use any one in particular.

This API call can only return 200 Client Ids at a time. It will take a
long time to execute if you have many Client Ids, as the function will
submit requests to the API repeatedly; this may even result in a timeout
error from the server. In order to provide data for troubleshooting
this function will write a message to the console after each call.
It is recommended that you divert the console output to a text file.
You can do this in multiple ways, including with the sink function (see
example for how to do this).

For the same reason you are encouraged to break your request into
smaller chunks using the install dates and/or splitting up your
product Ids.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
logout(rev_user, rev_pwd)
Sys.sleep(30)
revenera_auth(rev_user, rev_pwd)
product_ids_list <- c("123", "456", "789")
product_properties <- get_product_properties(product_ids_list)
sink("output_filename.txt") # write out chatty messages to a file
sink(stdout(), type = "message")
daily_client_properties <- get_daily_client_properties(product_ids_list,
  product_properties, c("Property1", "Property2"), 
  installed_start_date = "01-01-2020", installed_end_date = "01-31-2020",
  daily_start_date = "01-01-2020", daily_end_date = "01-31-2020",
  chatty = TRUE
)
sink()
}

}
