% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revenera_auth.R
\name{revenera_auth}
\alias{revenera_auth}
\title{Login and Obtain Revenera API Session Id}
\usage{
revenera_auth(rev_username, rev_password)
}
\arguments{
\item{rev_username}{Revenera username.}

\item{rev_password}{Revenera password.}
}
\value{
Cookie authorization (which you won't see), or an error message.
}
\description{
An authorizaton cookie must first be established before querying for data.
This is done using your Revenera username and password. If there is an 
active cookie this function will fail. You must `logout()` first then
}
\details{
It is not recommended that these values be stored directly
in your code. There are various methods and packages
available that are more secure; this package does not require
you to use any one in particular.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
logout(rev_user, rev_pwd)
Sys.sleep(30)
revenera_auth(rev_user, rev_pwd)
}

}
