% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_facts.R
\name{run_facts}
\alias{run_facts}
\title{Run FACTS}
\usage{
run_facts(
  facts_file,
  output_path = tempfile(),
  log_path = output_path,
  n_burn = NULL,
  n_mcmc = NULL,
  n_weeks_files = 10000,
  n_patients_files = 10000,
  n_mcmc_files = 0,
  n_mcmc_thin = NULL,
  flfll_seed = NULL,
  flfll_offset = NULL,
  ...
)
}
\arguments{
\item{facts_file}{Character, name of a FACTS file.
Usually has a \verb{*.facts} file extension.}

\item{output_path}{Character, directory path to the files to generate.}

\item{log_path}{Character, path to the log file generated by FLFLL.}

\item{n_burn}{Number of burn-in iterations for the MCMC.}

\item{n_mcmc}{Number of MCMC iterations used in inference.}

\item{n_weeks_files}{Number of \code{weeks*.csv} files to save in \code{output_path}.}

\item{n_patients_files}{Number of \code{patients*.csv} files to save in
\code{output_path}.}

\item{n_mcmc_files}{Number of \code{mcmc*.csv} files to save in
\code{output_path}.}

\item{n_mcmc_thin}{Number of thinning iterations for the MCMC.}

\item{flfll_seed}{Positive integer, random number generator seed for FLFLL.
This seed is only used for stochastic preprocessing steps for generating
the \verb{*.param} files. It is not the random number generator seed
for the actual trial simulations. To set the trial simulation seed,
use the \code{seed} argument of \code{\link[=run_facts]{run_facts()}}, \code{\link[=run_engine]{run_engine()}}, or
one of the specific \verb{run_engine*()} functions.}

\item{flfll_offset}{Integer, offset for the random number generator.}

\item{...}{Named arguments to the appropriate FACTS engine function.
Use \code{\link[=get_facts_engine]{get_facts_engine()}} to identify the appropriate
engine function and then open the help file of that function to read
about the arguments, e.g. \code{?run_engine_contin}.}
}
\value{
Character, path to the directory with FACTS output.
}
\description{
Run FACTS trial simulations.
}
\details{
\code{\link[=run_facts]{run_facts()}} calls \code{\link[=run_flfll]{run_flfll()}} and then \code{\link[=run_engine]{run_engine()}}.
For finer control over trial simulation, you can call these
latter two functions individually.
}
\examples{
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
facts_file <- get_facts_file_example("contin.facts") # example FACTS file
out <- run_facts(
  facts_file,
  n_sims = 4,
  verbose = FALSE
)
# What results files do we have?
head(get_csv_files(out))
# Read all the "patients*.csv" files with `read_patients(out)`.
# For each scenario, we have files named
# patients00001.csv, patients00002.csv, patients00003.csv,
# and patients00004.csv.
read_patients(out)
}
}
\seealso{
\code{\link[=run_flfll]{run_flfll()}}, \code{\link[=run_engine]{run_engine()}}, \code{\link[=get_facts_engine]{get_facts_engine()}}
}
