% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.arules.R
\name{ml.arules}
\alias{ml.arules}
\title{Mining Association rules and Frequent Itemsets}
\usage{
ml.arules(data, itemField, support = 0.5, confidence = 0.8, maxlen = 5,
  target = "rules")
}
\arguments{
\item{data}{an \link{ml.data.frame} object}

\item{itemField}{a ml.data.frame field which is the field that the itemsets will be created of. The underlying field needs to have a Range Index defined.}

\item{support}{a numeric value for the minimal support of an item set (default: 0.5)}

\item{confidence}{a numeric value for the minimal confidence of rules/association hyperedges (default: 0.8)}

\item{maxlen}{an integer value for the maximal number of items per item set (default: 5)}

\item{target}{a character string indicating the type of association mined. One of "frequent itemsets" or "rules", default is "rules"}
}
\value{
Returns an object of class rules or itemsets.
}
\description{
Mine frequent itemsets or association rules using MarkLogic Server built in Range Index functions.
The function require that there is a Range Index on the underlying field of itemField, a range indexe can
be created with the \link{ml.add.index} function. It will return a object that is of class rules or itemsets
as defined in the arules package. It will need the arules package installed.
}
\details{
The frequent itemset and association rules extraction method is using the same method as the Apriori
algorithm by first identify all 1-n itemsets that satisfy the support threshold and based on these
extract rules that satisfy the confidence threshold.

It is depended on that there are a Range Index on the underlying field for the itemField.
Information about the name of the field can be shown by \code{mlDataFrame$itemField}, where mlDataFrame
is a ml.data.frame object and itemField is the name of the field.
}

