% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_backbone.r
\name{name_backbone}
\alias{name_backbone}
\alias{name_backbone_verbose}
\title{Lookup names in the GBIF backbone taxonomy.}
\usage{
name_backbone(
  name,
  rank = NULL,
  kingdom = NULL,
  phylum = NULL,
  class = NULL,
  order = NULL,
  family = NULL,
  genus = NULL,
  strict = FALSE,
  verbose = FALSE,
  start = NULL,
  limit = 100,
  curlopts = list(http_version = 2)
)

name_backbone_verbose(
  name,
  rank = NULL,
  kingdom = NULL,
  phylum = NULL,
  class = NULL,
  order = NULL,
  family = NULL,
  genus = NULL,
  strict = FALSE,
  start = NULL,
  limit = 100,
  curlopts = list(http_version = 2)
)
}
\arguments{
\item{name}{(character) Full scientific name potentially with authorship
(required)}

\item{rank}{(character) The rank given as our rank enum. (optional)}

\item{kingdom}{(character) If provided default matching will also try to
match against this if no direct match is found for the name alone.
(optional)}

\item{phylum}{(character) If provided default matching will also try to
match against this if no direct match is found for the name alone.
(optional)}

\item{class}{(character) If provided default matching will also try to
match against this if no direct match is found for the name alone.
(optional)}

\item{order}{(character) If provided default matching will also try to
match against this if no direct match is found for the name alone.
(optional)}

\item{family}{(character) If provided default matching will also try to
match against this if no direct match is found for the name alone.
(optional)}

\item{genus}{(character) If provided default matching will also try to
match against this if no direct match is found for the name alone.
(optional)}

\item{strict}{(logical) If \code{TRUE} it (fuzzy) matches only the given name,
but never a taxon in the upper classification (optional)}

\item{verbose}{(logical) should the function give back more (less reliable)
results. See function \code{name_backbone_verbose()}}

\item{start}{Record number to start at. Default: 0. Use in combination
with \code{limit} to page through results.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
For \code{name_backbone}, a data.frame for a single taxon with many
columns. For \code{name_backbone_verbose}, a larger number of results in a
data.frame the results of resulting from fuzzy matching.
You will also get back your input name, rank, kingdom, phylum ect. as
columns input_name, input_rank, input_kingdom ect. so you can check the
results.
}
\description{
Lookup names in the GBIF backbone taxonomy.
}
\details{
If you don't get a match, GBIF gives back a data.frame with columns
\code{synonym}, \code{confidence}, and \code{matchType='NONE'}.
}
\examples{
\dontrun{
name_backbone(name='Helianthus annuus', kingdom='plants')
name_backbone(name='Helianthus', rank='genus', kingdom='plants')
name_backbone(name='Poa', rank='genus', family='Poaceae')

# Verbose - gives back alternatives
## Strictness
name_backbone_verbose(name='Poa', kingdom='plants',
  strict=FALSE)
name_backbone_verbose(name='Helianthus annuus', kingdom='plants',
  strict=TRUE)

# Non-existent name - returns list of lenght 3 stating no match
name_backbone(name='Aso')
name_backbone(name='Oenante')

# Pass on curl options
name_backbone(name='Oenante', curlopts = list(verbose=TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/species#searching}
}
