% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from.R
\name{gd_image_from_id}
\alias{gd_image_from_id}
\alias{gd_collection_from_name}
\alias{gd_collection_from_list}
\title{Reference Google Earth Engine Image or Image Collection by ID or Name}
\usage{
gd_image_from_id(x)

gd_collection_from_name(x)

gd_collection_from_list(x)
}
\arguments{
\item{x}{character. \code{id} of Image, \code{name} of Image Collection, or a vector of Image \code{id} to create a new Image Collection}
}
\value{
\code{geedim.MaskedImage} or \code{geedim.MaskedCollection} object, or \code{try-error} on error
}
\description{
Create references to a Google Earth Engine Image or Image Collection based on IDs or names, or combine Images into Image Collections.
}
\examples{
\dontshow{if (gd_is_initialized()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
if (gd_is_initialized())
  gd_image_from_id('CSP/ERGo/1_0/Global/SRTM_topoDiversity')
}
\dontshow{\}) # examplesIf}
\dontshow{if (gd_is_initialized()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
if (gd_is_initialized())
  gd_collection_from_name("USGS/3DEP/1m")
}
\dontshow{\}) # examplesIf}
\dontshow{if (gd_is_initialized()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
if (gd_is_initialized())
  gd_collection_from_list(c("USGS/3DEP/1m", "USGS/NED"))
}
\dontshow{\}) # examplesIf}
}
