% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{deletion_plots}
\alias{deletion_plots}
\title{Returns all main plots for a single deletion analysis result.}
\usage{
deletion_plots(
  del_result,
  opts = genie_plot_options(),
  variance_components_plot = FALSE,
  power_plots = FALSE
)
}
\arguments{
\item{del_result}{Result from a call to deletion_analysis.}

\item{opts}{A list with all options needed for rgenie plotting functions.}

\item{variance_components_plot}{If TRUE, then variance_components_plot() is called.}

\item{power_plots}{If TRUE, then power_plots() is called.}
}
\value{
Returns a list of ggplot objects.
}
\description{
Returns all main plots for a single deletion analysis result.
}
\examples{
# Note: First run deletion_analysis()
# mul1_del_results is a pre-loaded result

deletion_plots(mul1_del_results[[1]], genie_plot_options())
}
\seealso{
\code{\link{genie_plot_options}}

\code{\link{deletion_analysis}}

\code{\link{deletion_summary_plot}}

\code{\link{deletion_alleles_plot}}

\code{\link{deletion_profile_plot}}

\code{\link{replicate_summary_plot}}

\code{\link{replicate_qc_plot}}

\code{\link{allele_effect_plot}}

\code{\link{variance_components_plot}}

\code{\link{power_plots}}
}
