% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{quantile_breaks}
\alias{quantile_breaks}
\title{Quantile Breaks}
\usage{
quantile_breaks(k, data)
}
\arguments{
\item{k}{A numeric value indicates how many breaks}

\item{data}{A vector of numeric values}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Quantile breaks data into groups that each have the same number of observations
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
quantile_breaks(k=5, data=crm_prs)
}
