% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rglobi.R
\name{get_interaction_table}
\alias{get_interaction_table}
\title{Returns all known child taxa with known interaction of specified source and target taxa on any rank.}
\usage{
get_interaction_table(source.taxon.names = list(),
  target.taxon.names = list(), interaction.type = "preysOn", skip = 0,
  limit = 100, opts = list())
}
\arguments{
\item{source.taxon.names}{list of taxon names for source}

\item{target.taxon.names}{list of taxon names for target}

\item{interaction.type}{kind of interaction}

\item{skip}{number of records skipped before including record in result table, used in pagination}

\item{limit}{maximum number of interaction to include}

\item{opts}{connection parameters and other options}
}
\value{
table of matching source, target and interaction types
}
\description{
Returns all known child taxa with known interaction of specified source and target taxa on any rank.
}
\examples{
\dontrun{
get_interaction_table(source.taxon.names = list("Aves"), target.taxon.names = list('Insecta'))
}
}
\seealso{
Other interactions: \code{\link{get_child_taxa}};
  \code{\link{get_interaction_matrix}};
  \code{\link{get_interaction_types}};
  \code{\link{get_interactions_by_taxa}};
  \code{\link{get_interactions}};
  \code{\link{get_predators_of}}; \code{\link{get_prey_of}}
}

