% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-preprocessing.R
\name{DiagramSelector}
\alias{DiagramSelector}
\title{Preprocessing: Diagram Selector}
\description{
This is a class for extracting finite or essential points in
persistence diagrams.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new()
ds$apply(dgm)
ds$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:PreprocessingStep]{rgudhi::PreprocessingStep}} -> \code{DiagramSelector}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DiagramSelector-new}{\code{DiagramSelector$new()}}
\item \href{#method-DiagramSelector-clone}{\code{DiagramSelector$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="apply"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-apply'><code>rgudhi::PreprocessingStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit'><code>rgudhi::PreprocessingStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit_transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit_transform'><code>rgudhi::PreprocessingStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-transform'><code>rgudhi::PreprocessingStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiagramSelector-new"></a>}}
\if{latex}{\out{\hypertarget{method-DiagramSelector-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{DiagramSelector}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiagramSelector$new(
  use = FALSE,
  limit = Inf,
  point_type = c("finite", "essential")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use}}{A boolean value specifying whether to use the class. Defaults
to \code{FALSE}.}

\item{\code{limit}}{A numeric value specifying the second coordinate value which
is the criterion for being an essential point. Defaults to
\eqn{\infty}.}

\item{\code{point_type}}{A string specifying the type of the points that are
going to be extracted. Choices are either \verb{“finite”} or \verb{“essential”}.
Defaults to \verb{“finite”}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{DiagramSelector}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiagramSelector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DiagramSelector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiagramSelector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
