% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders_get.R
\name{borders_get}
\alias{borders_get}
\title{Get the boundaries of administrative units}
\usage{
borders_get(voivodeship = NULL, county = NULL, commune = NULL, TERYT = NULL)
}
\arguments{
\item{voivodeship}{selected voivodeships in Polish.
Check \code{\link[=voivodeship_names]{voivodeship_names()}} function}

\item{county}{county names in Polish.
Check \code{\link[=county_names]{county_names()}} function}

\item{commune}{commune names in Polish.
Check \code{\link[=commune_names]{commune_names()}} function}

\item{TERYT}{voivodeships, counties or communes (2, 4 or 7 characters)}
}
\value{
a sf data.frame (EPSG: 2180)
}
\description{
Get the boundaries of administrative units
}
\details{
If all arguments are NULL (default),
the boundary of Poland will be returned.
}
\examples{
\dontrun{
voivodeship_geom = borders_get(voivodeship = "lubuskie") # 494 KB
county_geom = borders_get(county = "Sopot") # 18 KB
commune_geom = borders_get(commune = c("Hel", "Krynica Morska")) # 11 KB
poland_geom = borders_get() # 1124.3 KB
}
}
