% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-class.R
\name{rhub-ids}
\alias{rhub-ids}
\title{R-hub check ids}
\description{
R-hub check ids
}
\section{R-hub ids}{


Every R-hub check has a unique id, that is constructed from the
name of the source package archive, and a random string. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{devtools_2.0.0.tar.gz-fe53bbba85de4a579f6dc3b852bf76a3
}\if{html}{\out{</div>}}
}

\section{R-hub group ids}{


For every check submission, R-hub also creates a unique check group id.
One check group may contain multiple checks. E.g. \code{\link[=check_for_cran]{check_for_cran()}}
typically creates three or four check groups. Group ids look the same
as individual check ids.
}

\section{Abbreviating ids}{


The rhub package keeps a list of all the checks that it has seen in the
current session, and these checks can be also referenced by any unique
prefix of the random string part of the id, e.g. in the \code{\link[=get_check]{get_check()}}
function. E.g. if rhub already know the devtools check above, then

\if{html}{\out{<div class="sourceCode r">}}\preformatted{get_check("fe53bbb")
}\if{html}{\out{</div>}}

works.

This is only recommended in interactive mode, and we suggest that you
always use the full ids when using rhub programmatically.
}

