% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{fromto}
\alias{fromto}
\title{translate between realms}
\usage{
fromto(
  x,
  from = "calBP",
  cc = 1,
  postbomb = 1,
  cc.dir = NULL,
  thiscurve = NULL,
  zero = TRUE,
  width = c(),
  digits = 0,
  C14.col = rgb(0, 0, 1, 0.5),
  D14C.col = rgb(0, 0.4, 0, 0.4),
  ka = FALSE,
  legend.size = 0.7
)
}
\arguments{
\item{x}{The value to be translated into other realms}

\item{from}{The realm of the entered value. Can be "calBP" for cal BP, "BCAD" for BC/AD, "C14" for C14 BP, "F14C" for F14C, or "pMC" for pMC. D14C cannot be entered as a value (you could enter the corresponding cal BP or BC/AD ages instead).}

\item{cc}{calibration curve for C14 (see \code{caldist()}).}

\item{postbomb}{Whether or not to use a postbomb curve (see \code{caldist()}).}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{zero}{Whether or not zero BC/AD should be included. Defaults to 0.}

\item{width}{Width of the righthand plot. Calculated automatically by default (older ages get wider windows).}

\item{digits}{Rounding of the reported values. Defaults to 0 digits.}

\item{C14.col}{Colour of the 14C calibration curve. Defaults to semi-transparent blue, \code{C14.col=rgb(0,0,1,.5)}.}

\item{D14C.col}{Colour of the D14C curve. Defaults to semi-transparent green, \code{D14C.col=rgb(0,.4,0,.4)}.}

\item{ka}{Whether to use years or ka (thousands of years). Defaults to \code{ka=FALSE}.}

\item{legend.size}{Size of the font of the legend. Defaults to 0.7 of R's standard size.}
}
\value{
A plot and output showing the translations into the different realms.
}
\description{
translate between realms
}
\details{
Upon entering a value and its realm, this function will find the corresponding values in the other realms. Note that uncertainties are *not* taken into account, and especially going from C14 BP to cal BP and BC/AD ignores many calibration-related uncertainties. D14C values are only reported for entered values on the cal BP or BC/AD scale.
}
\examples{
  fromto(0, "BCAD")
  fromto(2450, "C14")
}
