% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{F14CtopMC}
\alias{F14CtopMC}
\title{Calculate pMC ages from F14C values.}
\usage{
F14CtopMC(F14C, er = NULL, roundby = Inf)
}
\arguments{
\item{F14C}{Reported mean of the F14C}

\item{er}{Reported error of the F14C. Returns just the mean if left empty.}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=Inf}, no rounding.}
}
\value{
The pMC values from the F14C values. Basically the original values multiplied by 100.
}
\description{
Calculate pMC values from F14C values of radiocarbon dates.
}
\details{
Post-bomb dates are often reported as F14C (between 0 at c. 55 kcal BP and 1 at c. AD 1950). Since software such as Bacon expects radiocarbon ages,
 this function can be used to calculate radiocarbon ages from F14C values. The reverse function is \link{age.F14C}.
}
\examples{
  F14CtopMC(1.10, 0.5)
}
