% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_utils.R
\name{metric}
\alias{metric}
\title{Metric Object Constructor}
\usage{
metric(log, exp, vec, unvec)
}
\arguments{
\item{log}{A function representing the Riemannian logarithmic map. This function should accept a \code{dppMatrix} (the reference point) and another \code{dppMatrix} (the matrix whose logarithm is to be computed), and it outputs a \code{dspMatrix} (the tangent image).}

\item{exp}{A function representing the Riemannian exponential map. This function should accept a \code{dppMatrix} (the reference point) and a \code{dspMatrix} (the matrix whose exponential is to be computed) and return a \code{dppMatrix} (the image on the manifold).}

\item{vec}{A function representing the vectorization operation for tangent spaces. This function should accept a \code{dppMatrix} (the reference point) and a \code{dspMatrix} (the tangent image) and return a vector (the vectorized image).}

\item{unvec}{A function representing the inverse of the vectorization operation. This function should accept a \code{dppMatrix} (the reference point) and a vector (the vectorized image), and it returns a \code{dspMatrix} (the tangent image).}
}
\value{
An object of class \code{rmetric} containing the specified functions.
}
\description{
Constructs a metric object that contains the necessary functions for Riemannian operations.
}
