% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionalentropy.R
\name{conditional_entropy}
\alias{conditional_entropy}
\title{Conditional Entropy}
\usage{
conditional_entropy(xs, ys, local = FALSE)
}
\arguments{
\item{xs}{Vector specifying a time series drawn from
the conditional distribution.}

\item{ys}{Vector specifying a time series drawn from
the target distribution.}

\item{local}{Boolean specifying whether to compute the local conditional
entropy.}
}
\value{
Numeric giving the average conditional entropy or a vector giving the
        local conditional entropy.
}
\description{
Compute the average or the local conditional entropy between two time series.
This function expects the \strong{condition} to be the first argument.
}
\examples{
xs <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1)
ys <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1)
conditional_entropy(xs, ys)      # 0.5971072
conditional_entropy(ys, xs)      # 0.5077571

# [1] 3.0, 3.0, 0.1926451, 0.1926451, 0.1926451, 0.1926451, 0.1926451, 0.1926451,
#     0.1926451, 0.1926451, 0.1926451, 0.1926451, 0.1926451, 0.1926451, 0.1926451,
#     0.1926451, 0.4150375, 0.4150375, 0.4150375, 2.0
conditional_entropy(xs, ys, local = TRUE)

# [1] 1.32192809, 1.32192809, 0.09953567, 0.09953567, 0.09953567, 0.09953567,
#     0.09953567, 0.09953567, 0.09953567, 0.09953567, 0.09953567, 0.09953567,
#     0.09953567, 0.09953567, 0.09953567, 0.09953567, 0.73696559, 0.73696559,
#     0.73696559,  3.9068906
conditional_entropy(ys, xs, local = TRUE)

}
