% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{decode}
\alias{decode}
\title{Decode}
\usage{
decode(encoding, b, n = NA)
}
\arguments{
\item{encoding}{Numeric of the encoded state.}

\item{b}{Numeric giving the desired base.}

\item{n}{Numeric giving the desired number of digits.}
}
\value{
Vector giving the decoded state.
}
\description{
Decode an integer into a base-\code{b} array with \code{n} digits. Note that
the base \code{b} must be provided, but the number of digits \code{n} is
optional. If it is provided then the decoded state will have exactly that
many elements. If \code{n} is not provided, the length of the decoded state
is as small as possible.
}
\examples{
# The provided encoded state is decoded using the big-endian
# encoding scheme.
decode(2, b = 2, n = 2) # [1, 0]
decode(6, b = 2, n = 3) # [1, 1, 0]
decode(6, b = 3, n = 2) # [2, 0]

# If n is not provided, the length of the decoded state
# is as small as possible
decode(1, b = 2) # [1]
decode(1, b = 3) # [1]
decode(3, b = 2) # [1, 1]
decode(3, b = 3) # [1, 0]
decode(3, b = 4) # [3]

}
