% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R
\name{ils}
\alias{ils}
\title{List iRODS Data Objects and Collections}
\usage{
ils(
  logical_path = ".",
  stat = FALSE,
  permissions = FALSE,
  metadata = FALSE,
  offset = 0,
  limit = 100,
  message = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{logical_path}{Path to the collection whose contents are to be listed.
By default this is the current working collection (see \code{\link[=ipwd]{ipwd()}}).}

\item{stat}{Whether stat information should be included. Defaults to \code{FALSE}.}

\item{permissions}{Whether access control information should be included.
Defaults to \code{FALSE}.}

\item{metadata}{Whether metadata information should be included. Defaults to
\code{FALSE}.}

\item{offset}{Number of records to skip for pagination. Defaults to 0.}

\item{limit}{Number of records to show per page. Defaults to 100.}

\item{message}{Whether a message should be printed when the collection is
empty. Defaults to \code{TRUE}.}

\item{verbose}{Whether information should be printed about the HTTP request
and response. Defaults to \code{FALSE}.}
}
\value{
Dataframe with logical paths and, if requested, additional
information.
}
\description{
List the contents of a collection, optionally with stat, metadata, and/or
access control information for each element in the collection.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authenticate
iauth("rods", "rods")

# list home directory
ils()

# make collection
imkdir("some_collection")

# list a different directory
ils("/tempZone/home/rods/some_collection")

# show metadata
ils(metadata = TRUE)

# delete `some_collection`
irm("some_collection", force = TRUE, recursive = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=ipwd]{ipwd()}} for finding the working collection,
\code{\link[=ipwd]{ipwd()}} for setting the working collection, and
\code{\link[=list.files]{list.files()}} for an R equivalent.
}
