% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_host_info.R
\name{get_versions}
\alias{get_versions}
\title{Get Package Versions}
\usage{
get_versions(table, package_name)
}
\arguments{
\item{table}{A list of parsed package data (e.g., from `parse_html_version()`), where each element contains package details such as `package_version` and `date`.}

\item{package_name}{A character string specifying the name of the package to fetch versions for.}
}
\value{
A list with the following elements:
\describe{
  \item{all_versions}{A list of named lists, each containing:
    \describe{
      \item{version}{The version number of the package.}
      \item{date}{The associated publication date as a string.}
    }
  }
  \item{last_version}{A named list containing the latest version of the package with:
    \describe{
      \item{version}{The latest version number.}
      \item{date}{The publication date of the latest version.}
    }
    May be \code{NULL} if the API call fails.
  }
}
}
\description{
This function retrieves all available versions of a package, including the latest version,
by parsing the provided version table and querying the RStudio Package Manager.
}
\examples{
\dontrun{
# Define the input table
table <- list(
  list(
    package_name = "here",
    package_version = "0.1",
    link = "here_0.1.tar.gz",
    date = "2017-05-28 08:13",
    size = "3.5K"
  ),
  list(
    package_name = "here",
    package_version = "1.0.0",
    link = "here_1.0.0.tar.gz",
    date = "2020-11-15 18:10",
    size = "32K"
  )
)

result <- get_versions(table, "here")
print(result)
}

}
