% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCalibration.R
\name{plotCalibration}
\alias{plotCalibration}
\title{Plot Calibration curve}
\usage{
plotCalibration(x, models, times, method = "nne", round = TRUE,
  bandwidth = NULL, q = 10, bars = FALSE, hanging = FALSE,
  names = "quantiles", pseudo, rug, show.frequencies = FALSE, plot = TRUE,
  add = FALSE, diag = !add, legend = !add, auc.in.legend = TRUE,
  brier.in.legend = TRUE, axes = !add, xlim = c(0, 1), ylim = c(0, 1),
  xlab = ifelse(bars, "Risk groups", "Predicted risk"),
  ylab = "Observed frequency", col, lwd, lty, pch, type, cause = 1,
  percent = TRUE, na.action = na.fail, cex = 1, ...)
}
\arguments{
\item{x}{Object obtained with function \code{Score}}

\item{models}{Choice of models to plot}

\item{times}{Time point specifying the prediction horizon.}

\item{method}{The method for estimating the calibration curve(s):

\code{"nne"}: The expected event status is obtained in the nearest
neighborhood around the predicted event probabilities.

\code{"quantile"}: The expected event status is obtained in groups
defined by quantiles of the predicted event probabilities.}

\item{round}{If \code{TRUE} predicted probabilities are rounded to
two digits before smoothing. This may have a considerable
effect on computing efficiency in large data sets.}

\item{bandwidth}{The bandwidth for \code{method="nne"}}

\item{q}{The number of quantiles for \code{method="quantile"} and
\code{bars=TRUE}.}

\item{bars}{If \code{TRUE}, use barplots to show calibration.}

\item{hanging}{Barplots only. If \code{TRUE}, hang bars
corresponding to observed frequencies at the value of the
corresponding prediction.}

\item{names}{Barplots only. Names argument passed to
\code{names.arg} of \code{barplot}.}

\item{pseudo}{If \code{TRUE} show pseudo values (only for right
censored data).}

\item{rug}{If \code{TRUE} show rug plot at the predictions}

\item{show.frequencies}{Barplots only. If \code{TRUE}, show
frequencies above the bars.}

\item{plot}{If \code{FALSE}, do not plot the results, just return
a plottable object.}

\item{add}{If \code{TRUE} the line(s) are added to an existing
plot.}

\item{diag}{If \code{FALSE} no diagonal line is drawn.}

\item{legend}{Logical. If \code{TRUE} draw legend.}

\item{auc.in.legend}{Logical. If \code{TRUE} add AUC to legend.}

\item{brier.in.legend}{Logical. If \code{TRUE} add Brier score to
legend.}

\item{axes}{If \code{FALSE} no axes are drawn.}

\item{xlim}{Limits of x-axis.}

\item{ylim}{Limits of y-axis.}

\item{xlab}{Label for y-axis.}

\item{ylab}{Label for x-axis.}

\item{col}{Vector with colors, one for each element of
object. Passed to \code{\link{lines}}.}

\item{lwd}{Vector with line widths, one for each element of
object. Passed to \code{\link{lines}}.}

\item{lty}{lwd Vector with line style, one for each element of
object.  Passed to \code{\link{lines}}.}

\item{pch}{Passed to \code{\link{lines}}.}

\item{type}{Passed to \code{\link{lines}}.}

\item{cause}{For competing risks models, the cause of failure or
event of interest}

\item{percent}{If TRUE axes labels are multiplied by 100 and thus
interpretable on a percent scale.}

\item{na.action}{what to do with NA values. Passed to
\code{\link{model.frame}}}

\item{cex}{Default cex used for legend and labels.}

\item{...}{Used to control the subroutines: plot, axis, lines,
barplot, legend, addtable2plot, points (pseudo values), rug. See
\code{\link{SmartControl}}.}
}
\description{
Plot Calibration curve
}
\examples{
# binary 
db=sampleData(100,outcome="binary")
fb1=glm(Y~X1+X5+X7,data=db,family="binomial")
fb2=glm(Y~X1+X3+X6+X7,data=db,family="binomial")
xb=Score(list(model1=fb1,model2=fb2),Y~1,data=db,
          plots="cal")
plotCalibration(xb)

# survival
library(survival)
ds=sampleData(100,outcome="survival")
fs1=coxph(Surv(time,event)~X1+X5+X7,data=ds,x=1)
fs2=coxph(Surv(time,event)~X1+X3+X6+X7,data=ds,x=1)
xs=Score(list(Cox1=fs1,Cox2=fs2),Surv(time,event)~1,data=ds,
          plots="cal",metrics=NULL)
plotCalibration(xs)


# competing risks
data(Melanoma)
f1 <- CSC(Hist(time,status)~age+sex+epicel+ulcer,data=Melanoma)
f2 <- CSC(Hist(time,status)~age+sex+logthick+epicel+ulcer,data=Melanoma)
x <- Score(list(model1=f1,model2=f2),Hist(time,status)~1,data=Melanoma,
           cause= 2,times=5*365.25,plots="cal")
plotCalibration(x)
}
