% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{capture_expr_output}
\alias{capture_expr_output}
\title{Capture side effects issued by an evaluated expression}
\usage{
capture_expr_output(expr, split = FALSE, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{an expression to evaluate, capturing output events as they
are issued}

\item{split}{logical: if \code{TRUE}, output will be sent to the new
    sink and to the current output stream, like the Unix program \code{tee}.}

\item{env}{the environment in which \code{expr} should be evaluated,
defaulting to the calling environment.}

\item{quoted}{whether \code{expr} is a quoted object and should be evaluated
as is, or whether the expression should be captured from the function call.
Defaults to \code{FALSE}, capturing the passed expression.}
}
\value{
an with_eval_recording object
}
\description{
All messaging condition side effects are captured in the order that they
are issued.
}
\examples{
fn <- function() {
  print(paste(letters[1:3], collapse = ", "))
  warning("easy as")
  message(paste(1:3, collapse = ", "))
  message("simple as")
  warning("do re mi")
  return(3L)
}

capture_expr_output <- utils::getFromNamespace("capture_expr_output", "riskmetric")
console_output <- capture_expr_output(fn())

# console_output
# > fn()
# [1] "a, b, c"
# Warning in fn(): easy as
# 1, 2, 3
# simple as
# Warning in fn(): do re mi
# [1] 3

}
\keyword{internal}
