% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_score.R
\name{pkg_score}
\alias{pkg_score}
\title{Score a package assessment, collapsing results into a single numeric}
\usage{
pkg_score(x, ..., error_handler = score_error_default)
}
\arguments{
\item{x}{A \code{pkg_metric} object, whose subclass is used to choose the
appropriate scoring method for the atomic metric metadata. Optionally, a
\code{\link[tibble]{tibble}} can be provided, in which cases all
\code{pkg_metric} values will be scored.}

\item{...}{Additional arguments passed to \code{summarize_scores} when an
object of class \code{tbl_df} is provided, unused otherwise.}

\item{error_handler}{Specify a function to be called if the class can't be
identified. Most commonly this occurs for \code{pkg_metric} objects of
subclass \code{pkg_metric_error}, which is produced when an error is
encountered when calculating an associated assessment.}
}
\value{
A numeric value if a single \code{pkg_metric} is provided, or a
  \code{\link[tibble]{tibble}} with \code{pkg_metric} objects scored and
  returned as numeric values when a \code{\link[tibble]{tibble}} is provided.
}
\description{
pkg_score() calculates the risk involved with using a package. Risk ranges
from 0 (low-risk) to 1 (high-risk).
}
\examples{
# scoring a single assessment
metric_score(assess_has_news(pkg_ref("riskmetric")))

# scoring many assessments as a tibble
\dontrun{
library(dplyr)
pkg_score(pkg_assess(as_tibble(pkg_ref(c("riskmetric", "riskmetric")))))
}

}
\seealso{
score_error_default score_error_zero score_error_NA
}
