% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_popu.R
\name{comp_popu}
\alias{comp_popu}
\title{Compute a population table from frequencies.}
\format{An object of class \code{data.frame}
with \code{\link{N}} rows
and 3 columns (\code{"Truth", "Decision", "SDT"}).}
\usage{
comp_popu(hi = freq$hi, mi = freq$mi, fa = freq$fa, cr = freq$cr,
  cond.true.lbl = txt$cond.true.lbl, cond.false.lbl = txt$cond.false.lbl,
  dec.pos.lbl = txt$dec.pos.lbl, dec.neg.lbl = txt$dec.neg.lbl,
  hi.lbl = txt$hi.lbl, mi.lbl = txt$mi.lbl, fa.lbl = txt$fa.lbl,
  cr.lbl = txt$cr.lbl)
}
\arguments{
\item{hi}{The number of hits \code{\link{hi}} (or true positives).}

\item{mi}{The number of misses \code{\link{mi}} (or false negatives).}

\item{fa}{The number of false alarms \code{\link{fa}} (or false positives).}

\item{cr}{The number of correct rejections \code{\link{cr}} (or true negatives).}

\item{cond.true.lbl}{Text label for \code{\link{cond.true}} cases.}

\item{cond.false.lbl}{Text label for \code{\link{cond.false}} cases.}

\item{dec.pos.lbl}{Text label for \code{\link{dec.pos}} cases.}

\item{dec.neg.lbl}{Text label for \code{\link{dec.neg}} cases.}

\item{hi.lbl}{Text label for \code{\link{hi}} cases.}

\item{mi.lbl}{Text label for \code{\link{mi}} cases.}

\item{fa.lbl}{Text label for \code{\link{fa}} cases.}

\item{cr.lbl}{Text label for \code{\link{cr}} cases.}
}
\value{
A data frame \code{popu}
containing \code{\link{N}} rows (individual cases)
and 3 columns (\code{"Truth", "Decision", "SDT"})
encoded as ordered factors
(with 2, 2, and 4 levels, respectively).
}
\description{
\code{comp_popu} is a function that computes
a table \code{\link{popu}} (as an R data frame)
from the current frequency information
(contained in \code{\link{freq}}).
}
\details{
\code{comp_popu} also uses the current text settings
contained in \code{\link{txt}}.

A visualization of the current population
contained in \code{\link{popu}}
is provided by \code{plot_icon}.
}
\examples{
comp_popu(hi = 4, mi = 1, fa = 2, cr = 3)  # => computes a table of N = 10 cases

popu <- comp_popu()  # => initializes popu (with current values of freq and txt)
dim(popu)            # => N x 3
head(popu)           # => shows head of data frame


}
\seealso{
The corresponding data frame \code{\link{popu}};
\code{\link{num}} for basic numeric parameters;
\code{\link{freq}} for current frequency information;
\code{\link{txt}} for current text settings;
\code{\link{pal}} for current color settings.

Other functions computing frequencies: \code{\link{comp_freq_freq}},
  \code{\link{comp_freq_prob}}, \code{\link{comp_freq}},
  \code{\link{comp_min_N}}, \code{\link{comp_prob_prob}}
}
