% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{fa}
\alias{fa}
\alias{FP}
\alias{type-I-errors}
\title{Frequency of false alarms or false positives (FP).}
\format{An object of class \code{numeric} of length 1.}
\usage{
fa
}
\description{
\code{fa} is the frequency of false alarms
or false positives (\code{FP})
in a population of \code{\link{N}} individuals.
}
\details{
Definition:
\code{fa} is the frequency of individuals for which
\code{Condition = FALSE} and \code{Decision = TRUE} (positive).

\code{fa} is a measure of incorrect classifications
(type-I-errors), not an individual case.

Relationships:
\enumerate{
\item to probabilities:
The frequency \code{fa} depends on the false alarm rate \code{\link{fart}}
(aka. false positive rate, FPR)
and is conditional on the prevalence \code{\link{prev}}.

\item to other frequencies:
In a population of size \code{\link{N}}
the following relationships hold:

\itemize{

\item \code{\link{N} = \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N} = \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
   }
}
}
\seealso{
\code{\link{fart}} is the probability of false alarms
(aka. false positive rate \code{\link{FPR}} or \code{\link{fallout}});
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{is_freq}} verifies frequencies.

Other essential parameters: \code{\link{cr}},
  \code{\link{hi}}, \code{\link{mi}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}

Other frequencies: \code{\link{N}},
  \code{\link{cond.false}}, \code{\link{cond.true}},
  \code{\link{cr}}, \code{\link{dec.cor}},
  \code{\link{dec.err}}, \code{\link{dec.neg}},
  \code{\link{dec.pos}}, \code{\link{hi}}, \code{\link{mi}}
}
\keyword{datasets}
