% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{fart}
\alias{fart}
\alias{FPR}
\alias{alpha}
\alias{fallout}
\title{The false alarm rate (or false positive rate) of a decision process or diagnostic procedure.}
\format{An object of class \code{numeric} of length 1.}
\usage{
fart
}
\description{
\code{fart} defines a decision's false alarm rate
(or the rate of false positives): The conditional probability
of the decision being positive if the condition is FALSE.
}
\details{
Understanding or obtaining the false alarm rate \code{fart}:

\itemize{

\item Definition:
  \code{fart} is the conditional probability
  for an incorrect positive decision given that
  the condition is \code{FALSE}:

\code{fart = p(decision = positive | condition = FALSE)}

or the probability of a false alarm.

\item Perspective:
  \code{fart} further classifies
  the subset of \code{\link{cond.false}} individuals
  by decision (\code{fart = fa/cond.false}).

\item Alternative names:
  false positive rate (\code{FPR}),
  rate of type-I errors (\code{alpha}),
  statistical significance level,
  \code{fallout}

\item Relationships:

a. \code{fart} is the complement of the
  specificity \code{\link{spec}}:

\code{fart = 1 - spec}

b. \code{fart} is the opposite conditional probability
  -- but not the complement --
  of the false discovery rate
  or false detection rate \code{\link{FDR}}:

\code{FDR = p(condition = FALSE | decision = positive)}

\item In terms of frequencies,
  \code{fart} is the ratio of
  \code{\link{fa}} divided by \code{\link{cond.false}}
  (i.e., \code{\link{fa} + \link{cr}}):

\code{fart = fa/cond.false = fa/(fa + cr)}

\item Dependencies:
  \code{fart} is a feature of a decision process
  or diagnostic procedure and a measure of
  incorrect decisions (false positives).

However, due to being a conditional probability,
  the value of \code{fart} is not intrinsic to
  the decision process, but also depends on the
  condition's prevalence value \code{\link{prev}}.

}
}
\examples{
fart <- .25     # => sets a false alarm rate of 25\%
fart <- 25/100  # => (decision = positive) for 25 out of 100 people with (condition = FALSE)
is_prob(fart)   # => TRUE (as fart is a probability)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Sensitivity_and_specificity}{Wikipedia} for additional information.
}
\seealso{
\code{\link{comp_fart}} computes \code{fart} as the complement of \code{\link{spec}}
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probability inputs.

Other probabilities: \code{\link{FDR}}, \code{\link{FOR}},
  \code{\link{NPV}}, \code{\link{PPV}}, \code{\link{mirt}},
  \code{\link{ppod}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}
}
\keyword{datasets}
