% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{hi}
\alias{hi}
\alias{TP}
\title{Frequency of hits or true positives (TP).}
\format{An object of class \code{numeric} of length 1.}
\usage{
hi
}
\description{
\code{hi} is the frequency of hits
or true positives (\code{TP})
in a population of \code{\link{N}} individuals.
}
\details{
Definition: \code{hi}
is the frequency of individuals for which
\code{Condition = TRUE} and \code{Decision = TRUE} (positive).

\code{hi} is a measure of correct classifications,
not an individual case.

Relationships:
\enumerate{
\item to probabilities:
The frequency \code{hi} depends on the sensitivity \code{\link{sens}}
(aka. hit rate or true positive rate, TPR)
and is conditional on the prevalence \code{\link{prev}}.

\item to other frequencies:
In a population of size \code{\link{N}}
the following relationships hold:

\itemize{

\item \code{\link{N} = \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N} = \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
   }
}
}
\seealso{
\code{\link{sens}} is the probability of hits or hit rate \code{\link{HR}};
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{is_freq}} verifies frequencies.

Other frequencies: \code{\link{N}},
  \code{\link{cond.false}}, \code{\link{cond.true}},
  \code{\link{cr}}, \code{\link{dec.cor}},
  \code{\link{dec.err}}, \code{\link{dec.neg}},
  \code{\link{dec.pos}}, \code{\link{fa}}, \code{\link{mi}}

Other essential parameters: \code{\link{cr}},
  \code{\link{fa}}, \code{\link{mi}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}
}
\keyword{datasets}
