% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mosaic.R
\name{plot_mosaic}
\alias{plot_mosaic}
\title{Plot a mosaic plot of population frequencies.}
\usage{
plot_mosaic(prev = num$prev, sens = num$sens, mirt = NA,
  spec = num$spec, fart = NA, N = num$N, vsplit = TRUE,
  show.accu = TRUE, w.acc = 0.5, title.lbl = txt$scen.lbl,
  col.sdt = c(pal["hi"], pal["mi"], pal["fa"], pal["cr"]))
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{N}{The number of individuals in the population.
(This value is not represented in the plot,
but used when new frequency information \code{\link{freq}}
and a new population table \code{\link{popu}}
are computed from scratch from current probabilities.)}

\item{vsplit}{Option for toggling between
vertical and horizontal split.
Default: \code{vsplit = TRUE}.}

\item{show.accu}{Option for showing current
accuracy metrics \code{\link{accu}} in the plot.
Default: \code{show.accu = TRUE}.}

\item{w.acc}{Weigthing parameter \code{w} used to compute
weighted accuracy \code{w.acc} in \code{\link{comp_accu}}.
Default: \code{w.acc = .50}.}

\item{title.lbl}{Text label for current plot title.
Default: \code{title.lbl = txt$scen.lbl}.}

\item{col.sdt}{Colors for cases of 4 essential frequencies.
Default: \code{col.sdt = c(pal["hi"], pal["mi"], pal["fa"], pal["cr"])}.}
}
\description{
\code{plot_mosaic} draws a mosaic plot that
represents the proportions of frequencies in the current
population \code{\link{popu}} as relatives sizes of
rectangular areas.
}
\details{
If a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}})
is provided, new frequency information \code{\link{freq}}
and a new population table \code{\link{popu}}
are computed from scratch.  Otherwise, the existing
population \code{\link{popu}} is shown.

Rectangles corresponding to the areas of the mosaic plot
can be visualized byopting for vertical rectangles (by selecting
the option \code{box = "vr"}) in \code{\link{plot_tree}}
and \code{\link{plot_fnet}}.

\code{plot_mosaic} requires and uses the R packages "vcd" and
"grid" (\code{library("vcd", "grid")}).
}
\examples{
plot_mosaic()                # => default options
plot_mosaic(title.lbl = "")  # => no title
plot_mosaic(vsplit = FALSE)  # => horizontal split
plot_mosaic(title.lbl = "My favorite scenario", col.sdt = "goldenrod")

# Accuracy:
plot_mosaic(show.accu = TRUE)               # => default w = .5 (balanced accuracy "bacc")
plot_mosaic(show.accu = TRUE, w.acc = 1/3)  # => (weighted accuracy "wacc")
plot_mosaic(show.accu = FALSE)              # => no accuracy info.


}
\seealso{
\code{\link{comp_popu}} computes the current population;
\code{\link{popu}} contains the current population;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{freq}} contains current frequency information;
\code{\link{num}} for basic numeric parameters;
\code{\link{txt}} for current text settings;
\code{\link{pal}} for current color settings

Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_curve}}, \code{\link{plot_fnet}},
  \code{\link{plot_icons}}, \code{\link{plot_plane}},
  \code{\link{plot_tree}}
}
