% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_acc}
\alias{comp_acc}
\title{Compute overall accuracy (acc) from probabilities.}
\usage{
comp_acc(prev, sens, spec)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}
}
\value{
Overall accuracy \code{\link{acc}} as a probability (proportion).
A warning is provided for NaN values.

See \code{\link{acc}} for definition
and \code{\link{accu}} for other accuracy metrics.
\code{\link{comp_accu_freq}} and \code{\link{comp_accu_prob}}
compute accuracy metrics from frequencies and probabilities.
}
\description{
\code{comp_acc} computes overall accuracy \code{\link{acc}}
from 3 essential probabilities
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}.
}
\details{
\code{comp_acc} uses probabilities (not frequencies) as
inputs and returns an exact probability (proportion)
without rounding.

Understanding the probability \code{\link{acc}}:

\itemize{

\item Definition:
  \code{\link{acc}} is the (non-conditional) probability:

\code{acc = p(dec_cor) = dec_cor/N}

or the base rate (or baseline probability)
  of a decision being correct, but not necessarily positive.

\code{\link{acc}} values range
  from 0 (no correct decision/prediction)
  to 1 (perfect decision/prediction).

\item Computation: \code{\link{acc}} can be computed in 2 ways:

(a) from \code{\link{prob}}: \code{acc = (prev x sens) + [(1 - prev) x spec]}

(b) from \code{\link{freq}}: \code{acc = dec_cor/N = (hi + cr)/(hi + mi + fa + cr)}

When frequencies in \code{\link{freq}} are not rounded, (b) coincides with (a).

\item Perspective:
  \code{\link{acc}} classifies a population of \code{\link{N}} individuals
  by accuracy/correspondence (\code{acc = dec_cor/N}).

\code{\link{acc}} is the "by accuracy" or "by correspondence" counterpart
  to \code{\link{prev}} (which adopts a "by condition" perspective) and
  to \code{\link{ppod}} (which adopts a "by decision" perspective).

\item Alternative names of \code{\link{acc}}:
  base rate of correct decisions,
  non-erroneous cases

\item In terms of frequencies,
  \code{\link{acc}} is the ratio of
  \code{\link{dec_cor}} (i.e., \code{\link{hi} + \link{cr}})
  divided by \code{\link{N}} (i.e.,
  \code{\link{hi} + \link{mi}} + \code{\link{fa} + \link{cr}}):

\code{acc = dec_cor/N = (hi + cr)/(hi + mi + fa + cr)}

\item Dependencies:
  \code{\link{acc}} is a feature of both the environment (true condition) and
  of the decision process or diagnostic procedure. It reflects the
  correspondence of decisions to conditions.

}

See \code{\link{accu}} for other accuracy metrics
and several possible interpretations of accuracy.
}
\examples{
# ways to work:
comp_acc(.10, .200, .300)  # => acc = 0.29
comp_acc(.50, .333, .666)  # => acc = 0.4995

# watch out for vectors:
prev.range <- seq(0, 1, by = .1)
comp_acc(prev.range, .5, .5)  # => 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5

# watch out for extreme values:
comp_acc(1, 1, 1)  #  => 1
comp_acc(1, 1, 0)  #  => 1

comp_acc(1, 0, 1)  #  => 0
comp_acc(1, 0, 0)  #  => 0

comp_acc(0, 1, 1)  #  => 1
comp_acc(0, 1, 0)  #  => 0

comp_acc(0, 0, 1)  #  => 1
comp_acc(0, 0, 0)  #  => 0

}
\seealso{
\code{\link{acc}} defines accuracy as a probability;
\code{\link{accu}} lists all accuracy metrics;
\code{\link{comp_accu_prob}} computes exact accuracy metrics from probabilities;
\code{\link{comp_accu_freq}} computes accuracy metrics from frequencies;
\code{\link{comp_sens}} and \code{\link{comp_PPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu_freq}},
  \code{\link{comp_accu_prob}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_err}}, \code{\link{comp_fart}},
  \code{\link{comp_mirt}}, \code{\link{comp_ppod}},
  \code{\link{comp_prob_freq}}, \code{\link{comp_prob}},
  \code{\link{comp_sens}}, \code{\link{comp_spec}}

Other metrics: \code{\link{accu}}, \code{\link{acc}},
  \code{\link{comp_accu_freq}},
  \code{\link{comp_accu_prob}}, \code{\link{comp_err}},
  \code{\link{err}}
}
\concept{functions computing probabilities}
\concept{metrics}
