% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comment_detail.R
\name{comment_detail}
\alias{comment_detail}
\title{Get comment detail from TSN}
\usage{
comment_detail(tsn, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame with results.
}
\description{
Get comment detail from TSN
}
\examples{
\dontrun{
comment_detail(tsn=180543)
comment_detail(tsn=180543, wt = "xml")
library(httr)
comment_detail(tsn=180543)
}
}

