% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{record}
\alias{record}
\title{Gets a record from an LSID}
\usage{
record(lsid, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{lsid}{lsid for a taxonomic group (character). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame
}
\description{
Gets a record from an LSID
}
\details{
Gets the partial ITIS record for the TSN in the LSID, found by comparing the
 TSN in the search key to the TSN field. Returns an empty result set if
 there is no match or the TSN is invalid.
}
\examples{
\dontrun{
record(lsid = "urn:lsid:itis.gov:itis_tsn:180543")
}
}

