% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_common.R
\name{search_common}
\alias{search_common}
\title{Search for tsn by common name}
\usage{
search_common(x, from = "all", wt = "json", raw = FALSE, ...)
}
\arguments{
\item{x}{text or taxonomic serial number (TSN) (character or numeric)}

\item{from}{(character) One of "all", "begin", or "end". See Details.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame
}
\description{
Search for tsn by common name
}
\details{
The \code{from} parameter:
\itemize{
 \item all - Search against the \code{searchByCommonName} API route, which
 searches entire name string
 \item begin - Search against the \code{searchByCommonNameBeginsWith} API route, which
 searches for a match at the beginning of a name string
 \item end - Search against the \code{searchByCommonNameEndsWith} API route, which
 searches for a match at the end of a name string
}
}
\examples{
\dontrun{
search_common(x = "american bullfrog")
search_common("ferret-badger")
search_common("polar bear")

# comparison: all, begin, end
search_common("inch")
search_common("inch", from = "begin")
search_common("inch", from = "end")

# end
search_common("snake", from = "end")
}
}
\seealso{
\code{\link{search_scientific}}
}

