% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RiverAxisLabel.R
\name{RiverAxisLabel}
\alias{RiverAxisLabel}
\title{River Axis Labels}
\usage{
RiverAxisLabel(label, riverlayout, cex = 0.7, adj = c(0.5, -2), srt = 90,
  col = "black", pos = NULL, offset = 0.5, side = "L",
  mainonly = TRUE)
}
\arguments{
\item{label}{the axis label to be shown on the river chart.}

\item{riverlayout}{the output list of \code{RiverLayout}.}

\item{cex}{text size.}

\item{adj}{text adjustment. One or two values in the range [0,1] for x and y
(optional) adjustment.}

\item{srt}{text angle.}

\item{col}{text colour.}

\item{pos}{text position. \code{1} for below, \code{2} for left, \code{3}
for above, and \code{4} for right. See \code{par} for details.}

\item{offset}{text position offset.}

\item{side}{left (\code{"L"}) or right (\code{"R"}) axis.}

\item{mainonly}{the axis title is only shown for the main stream only
(\code{"TRUE"}) or not (\code{"FALSE"}).}
}
\description{
This adds left or right axis labels to the river chart.
}
\examples{
# see examples below
data(Ballinderry)

riverlayout <- RiverLayout(B.river$River,B.river$Length,
                           B.river$Parent,B.river$Position,
                           B.river$Distance, direction = -1)
RiverDraw(riverlayout)

RiverBar(B.siteaspt$Site, B.siteaspt$River, B.siteaspt$Distance,
         B.siteaspt[4:5], riverlayout, range = c(0,8),
         bar.col = c("#5381FFFF", "#FF3931FF"), lbl.adj = c(0.5,1.3))

RiverTM(c(0,2,4,6,8,10), B.siteaspt[4:5], riverlayout,
        pos=-1, side = "L", range = c(0,8), label = c(0,2,4,6,8))

RiverAxisLabel("ASPT score", riverlayout, adj = c(0.5, -3))
}
\author{
Feng Mao
}
\seealso{
\code{\link{RiverLayout}}, \code{\link{RiverDraw}},
\code{\link{RiverMap}}.  \code{\link{par}}.
}
\keyword{hplot}

