% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{update_metadata}
\alias{update_metadata}
\alias{update_metadata_roughly}
\title{Update the metadata from a workspace}
\usage{
update_metadata(ws_from, ws_to)

update_metadata_roughly(ws_from, ws_to)
}
\arguments{
\item{ws_from}{Workspace that contains the new metadata.}

\item{ws_to}{Workspace to update.}
}
\value{
the updated \code{workspace}
}
\description{
Functions to update the metadata of a workspace by those contained in
another one
}
\details{
\code{update_metadata()} checks the SA-Processings and SaItems' names
within the two workspaces before updating ws_to's metadata.
\code{update_metadata_roughly()} does not do any checks: \code{ws_to}'s first
SA-Processing's first SaItem metadata
is updated with \code{ws_from}'s first SA-Processing's first SaItem metadata.
Both functions create and return a new workspace containing
the updated series.
}
\examples{

library("RJDemetra")

path_to_ws1 <- file.path(
    system.file("extdata", package = "rjdworkspace"),
    "WS/ws_example_1.xml"
)
path_to_ws2 <- file.path(
    system.file("extdata", package = "rjdworkspace"),
    "WS/ws_example_2.xml"
)

ws_1 <- load_workspace(path_to_ws1)
compute(ws_1)
ws_2 <- load_workspace(path_to_ws2)
compute(ws_2)

updated_workspace <- update_metadata_roughly(ws_from = ws_1, ws_to = ws_2)
path_to_output <- file.path(tempdir(), "ws_update_meta_roughly.xml")
save_workspace(workspace = updated_workspace, file = path_to_output)

updated_workspace <- update_metadata(ws_from = ws_1, ws_to = ws_2)
path_to_output <- file.path(tempdir(), "ws_update_meta.xml")
save_workspace(workspace = updated_workspace, file = path_to_output)

}
