% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{zigzag_rr}
\alias{zigzag_rr}
\title{zigzag_rr}
\usage{
zigzag_rr(
  maxTime,
  dataX,
  datay,
  prior_sigma2,
  x0,
  theta0,
  rj_val = 0.5,
  ppi = 0.5,
  nmax = 10^6L,
  burn = -1L
)
}
\arguments{
\item{maxTime}{Maximum runtime (in Seconds) of the algorithm; will terminate the code after a given computation time or nmax iterations of the algorithm is reached.}

\item{dataX}{Matrix of all covariates where the i-th row corresponds to all p covariates x_{i,1}, ..., x_{i,p} of the i-th observation.}

\item{datay}{Vector of n observations of a continuous response variable y.}

\item{prior_sigma2}{Double for the prior variance for included variables.}

\item{x0}{Initial position of the regression parameter}

\item{theta0}{Initial velocity for the sampler (Default has 1s on all components). This should be chosen with unit velocities on each component (regardless of sign).}

\item{rj_val}{Reversible jump parameter for the PDMP method. This value is fixed over all models and is interpreted as the probability to jump to a reduced model when a parameter hits zero.}

\item{ppi}{Double for the prior probability of inclusion (ppi) for each parameter.}

\item{nmax}{Maximum number of iterations (simulated events) of the algorithm; will stop the algorithm when this number of iterations of the method have occured. Default value is 10^6, lower values should be chosen for memory constraints if less iterations are desired.}

\item{burn}{Optional number of iterations to use for burnin. These are not stored so can be useful in memory intensive problems.}
}
\value{
Returns a list with the following objects:

\code{times}: Vector of event times where ZigZag process switchs velocity or jumps models.

\code{positions}: Matrix of positions at which event times occur, these are not samples from the PDMP.

\code{theta}: Matrix of new velocities at event times.
}
\description{
Applies the Reversible Jump ZigZag Sampler to a Robust Regression problem with dirac spike and slab prior.
Included variables are given an independent Gaussian prior with variance \code{prior_sigma2} and mean zero, variables are given prior probabilities of inclusion \code{ppi}.
}
\examples{

generate.rr.data <- function(beta, n, Sig, noise, interc = TRUE) {
p <- length(beta)-(interc == TRUE)
dataX <- MASS::mvrnorm(n=n,mu=rep(0,p),Sigma=Sig)
if(interc) {dataX <- cbind(1, dataX)}
dataY <- rep(0, n)
dataY <- dataX \%*\% as.vector(beta)+rnorm(n, sd = sqrt(noise))
return(list(dataX = dataX, dataY = dataY))
}
p <- 3;
n<- 120
beta <- c(0.5,0.5, rep(0,p-1))
set.seed(1)
data <- generate.rr.data(beta,n,diag(1,p+1), noise = 2, interc = FALSE)
dataX <- data$dataX; dataY <- data$dataY

set.seed(1)
ppi_val <- 1/4
res <- zigzag_rr(maxTime = 1, dataX = dataX, datay = dataY,
                 prior_sigma2 = 10^2, x0 = rep(0,p+1), theta0 = rep(0,p+1),
                 rj_val = 0.6, ppi = ppi_val, nmax = 10^5)
plot_pdmp(res, coords = 1:3, inds = 1:10^3)

}
