/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.PartitionTopicInfo;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001]4\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\u0016\u0007>t7/^7fe\u001a+Go\u00195feRC'/Z1e\u0015\t\u0019A!\u0001\u0005d_:\u001cX/\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011QB\u0003\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011U\u0001!\u0011!Q\u0001\nY\tAA\\1nKB\u0011qC\u0007\b\u0003\u001faI!!\u0007\t\u0002\rA\u0013X\rZ3g\u0013\tYBD\u0001\u0004TiJLgn\u001a\u0006\u00033AA\u0001B\b\u0001\u0003\u0006\u0004%\taH\u0001\u0007G>tg-[4\u0016\u0003\u0001\u0002\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u001d\r{gn];nKJ\u001cuN\u001c4jO\"AQ\u0005\u0001B\u0001B\u0003%\u0001%A\u0004d_:4\u0017n\u001a\u0011\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nAb]8ve\u000e,'I]8lKJ\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0003\u0002\u000f\rdWo\u001d;fe&\u0011QF\u000b\u0002\u0007\u0005J|7.\u001a:\t\u0011=\u0002!\u0011!Q\u0001\nA\nA\u0002]1si&$\u0018n\u001c8NCB\u0004BaF\u00194s%\u0011!\u0007\b\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0005\u0003\u0019\u0019w.\\7p]&\u0011\u0001(\u000e\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007CA\u0011;\u0013\tY$A\u0001\nQCJ$\u0018\u000e^5p]R{\u0007/[2J]\u001a|\u0007\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011\u0001 \u0002-\r|gn];nKJ4U\r^2iKJl\u0015M\\1hKJ,\u0012a\u0010\t\u0003C\u0001K!!\u0011\u0002\u0003-\r{gn];nKJ4U\r^2iKJl\u0015M\\1hKJD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0018G>t7/^7fe\u001a+Go\u00195fe6\u000bg.Y4fe\u0002BQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDCB$I\u0013*[E\n\u0005\u0002\"\u0001!)Q\u0003\u0012a\u0001-!)a\u0004\u0012a\u0001A!)q\u0005\u0012a\u0001Q!)q\u0006\u0012a\u0001a!)Q\b\u0012a\u0001\u007f!)a\n\u0001C\u0001\u001f\u0006!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$B\u0001U*V5B\u0011q\"U\u0005\u0003%B\u0011A!\u00168ji\")A+\u0014a\u0001g\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u000bYk\u0005\u0019A,\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\t\u0003\u001faK!!\u0017\t\u0003\t1{gn\u001a\u0005\u000676\u0003\r\u0001X\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\u0005u\u0003W\"\u00010\u000b\u0005}#\u0011aA1qS&\u0011\u0011M\u0018\u0002\u001b\r\u0016$8\r\u001b*fgB|gn]3QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\u0006G\u0002!\t\u0001Z\u0001\u0017Q\u0006tG\r\\3PM\u001a\u001cX\r^(vi>3'+\u00198hKR\u0011q+\u001a\u0005\u0006)\n\u0004\ra\r\u0005\u0006O\u0002!\t\u0001[\u0001\u001bQ\u0006tG\r\\3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5FeJ|'o\u001d\u000b\u0003!&DQA\u001b4A\u0002-\f!\u0002]1si&$\u0018n\u001c8t!\raGo\r\b\u0003[Jt!A\\9\u000e\u0003=T!\u0001\u001d\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA:\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001e<\u0003\u0011%#XM]1cY\u0016T!a\u001d\t")
public class ConsumerFetcherThread
extends AbstractFetcherThread
implements ScalaObject {
    private final ConsumerConfig config;
    private final Map<TopicAndPartition, PartitionTopicInfo> partitionMap;
    private final ConsumerFetcherManager consumerFetcherManager;

    public ConsumerConfig config() {
        return this.config;
    }

    public ConsumerFetcherManager consumerFetcherManager() {
        return this.consumerFetcherManager;
    }

    @Override
    public void processPartitionData(TopicAndPartition topicAndPartition, long fetchOffset, FetchResponsePartitionData partitionData) {
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply(topicAndPartition);
        if (pti.getFetchOffset() != fetchOffset) {
            throw new RuntimeException(Predef$.MODULE$.augmentString("Offset doesn't match for partition [%s,%d] pti offset: %d fetch offset: %d").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition.topic(), BoxesRunTime.boxToInteger(topicAndPartition.partition()), BoxesRunTime.boxToLong(pti.getFetchOffset()), BoxesRunTime.boxToLong(fetchOffset)})));
        }
        pti.enqueue((ByteBufferMessageSet)partitionData.messages());
    }

    @Override
    public long handleOffsetOutOfRange(TopicAndPartition topicAndPartition) {
        String string2;
        long startTimestamp = 0L;
        String string3 = string2 = this.config().autoOffsetReset();
        String string4 = OffsetRequest$.MODULE$.SmallestTimeString();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            startTimestamp = OffsetRequest$.MODULE$.EarliestTime();
        } else {
            String string5 = string2;
            String string6 = OffsetRequest$.MODULE$.LargestTimeString();
            startTimestamp = !(string5 != null ? !string5.equals(string6) : string6 != null) ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.LatestTime();
        }
        long newOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, startTimestamp, Request$.MODULE$.OrdinaryConsumerId());
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply(topicAndPartition);
        pti.resetFetchOffset(newOffset);
        pti.resetConsumeOffset(newOffset);
        return newOffset;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicAndPartition> partitions) {
        this.removePartitions(partitions.toSet());
        this.consumerFetcherManager().addPartitionsWithError(partitions);
    }

    public ConsumerFetcherThread(String name, ConsumerConfig config, Broker sourceBroker, Map<TopicAndPartition, PartitionTopicInfo> partitionMap, ConsumerFetcherManager consumerFetcherManager) {
        this.config = config;
        this.partitionMap = partitionMap;
        this.consumerFetcherManager = consumerFetcherManager;
        super(name, new StringBuilder().append((Object)config.clientId()).append((Object)"-").append((Object)name).toString(), sourceBroker, config.socketTimeoutMs(), config.socketReceiveBufferBytes(), config.fetchMessageMaxBytes(), Request$.MODULE$.OrdinaryConsumerId(), config.fetchWaitMaxMs(), config.fetchMinBytes(), true);
    }
}

