% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{Evaluate.Kernel}
\alias{Evaluate.Kernel}
\title{Evaluate Kernel}
\usage{
Evaluate.Kernel(kernel, X)
}
\arguments{
\item{kernel}{a kernel class object}

\item{X}{input data}
}
\value{
The kernel (correlation) matrix of X evaluated by the kernel.
}
\description{
This function computes the kernel (correlation) matrix.
Given the kernel class object and the input data \eqn{X}{X} of size n, 
this function computes the corresponding \eqn{n\times n}{n x n} kernel (correlation) matrix.
}
\examples{
n <- 5
p <- 3
X <- matrix(rnorm(n*p), ncol=p)
lengthscale <- c(1:p)

kernel <- Gaussian.Kernel(lengthscale)
Evaluate.Kernel(kernel, X)

}
\seealso{
\link{Get.Kernel}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
