% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-defuse.R
\name{defusing-advanced}
\alias{defusing-advanced}
\alias{enexpr}
\alias{exprs}
\alias{enexprs}
\alias{ensym}
\alias{ensyms}
\alias{quo}
\alias{quos}
\alias{enquo0}
\alias{enquos0}
\title{Advanced defusal operators}
\usage{
enexpr(arg)

exprs(
  ...,
  .named = FALSE,
  .ignore_empty = c("trailing", "none", "all"),
  .unquote_names = TRUE
)

enexprs(
  ...,
  .named = FALSE,
  .ignore_empty = c("trailing", "none", "all"),
  .unquote_names = TRUE,
  .homonyms = c("keep", "first", "last", "error"),
  .check_assign = FALSE
)

ensym(arg)

ensyms(
  ...,
  .named = FALSE,
  .ignore_empty = c("trailing", "none", "all"),
  .unquote_names = TRUE,
  .homonyms = c("keep", "first", "last", "error"),
  .check_assign = FALSE
)

quo(expr)

quos(
  ...,
  .named = FALSE,
  .ignore_empty = c("trailing", "none", "all"),
  .unquote_names = TRUE
)

enquo0(arg)

enquos0(...)
}
\arguments{
\item{arg}{An unquoted argument name. The expression
supplied to that argument is defused and returned.}

\item{...}{For \code{enexprs()}, \code{ensyms()} and \code{enquos()}, names of
arguments to defuse. For \code{exprs()} and \code{quos()}, expressions
to defuse.}

\item{.named}{If \code{TRUE}, unnamed inputs are automatically named
with \code{\link[=as_label]{as_label()}}. This is equivalent to applying
\code{\link[=exprs_auto_name]{exprs_auto_name()}} on the result. If \code{FALSE}, unnamed elements
are left as is and, if fully unnamed, the list is given minimal
names (a vector of \code{""}). If \code{NULL}, fully unnamed results are
left with \code{NULL} names.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty. Named arguments are not
considered empty.}

\item{.unquote_names}{Whether to treat \verb{:=} as \code{=}. Unlike \code{=}, the
\verb{:=} syntax supports \link[=glue-operators]{names injection}.}

\item{.homonyms}{How to treat arguments with the same name. The
default, \code{"keep"}, preserves these arguments. Set \code{.homonyms} to
\code{"first"} to only keep the first occurrences, to \code{"last"} to keep
the last occurrences, and to \code{"error"} to raise an informative
error and indicate what arguments have duplicated names.}

\item{.check_assign}{Whether to check for \verb{<-} calls. When \code{TRUE} a
warning recommends users to use \code{=} if they meant to match a
function parameter or wrap the \verb{<-} call in curly braces otherwise.
This ensures assignments are explicit.}

\item{expr}{An expression to defuse.}
}
\description{
These advanced operators \link[=topic-defuse]{defuse} R expressions.
\code{\link[=expr]{expr()}}, \code{\link[=enquo]{enquo()}}, and \code{\link[=enquos]{enquos()}} are sufficient for most
purposes but rlang provides these other operations, either for
completeness or because they are useful to experts.
\itemize{
\item \code{exprs()} is the plural variant of \code{expr()}. It returns a list of
expressions. It is like \code{\link[base:list]{base::alist()}} but with
\link[=nse-inject]{injection} support.
\item \code{quo()} and \code{quos()} are like \code{expr()} and \code{exprs()} but return
quosures instead of naked expressions. When you are defusing
your own local expressions (by opposition to function arguments
where non-local expressions are supplied by your users), there
is generally no need to attach the current environment in a
quosure. See \ifelse{html}{\link[=topic-quosure]{What are quosures and when are they needed?}}{\link[=topic-quosure]{What are quosures and when are they needed?}}.
\item \code{enexpr()} and \code{enexprs()} are like \code{\link[=enquo]{enquo()}} and \code{\link[=enquos]{enquos()}} but
return naked expressions instead of quosures. These operators
should very rarely be used because they lose track of the
environment of defused arguments.
\item \code{ensym()} and \code{ensyms()} are like \code{enexpr()} and \code{enexprs()} but
they throw an error when the defused expressions are not simple
symbols. They also support strings which are interpreted as
symbols. These functions are modelled on the behaviour of the
left-hand side of \code{=} and \verb{<-} where you can supply symbols and
strings interchangeably.

\if{html}{\out{<div class="sourceCode">}}\preformatted{"foo" <- NULL
list("foo" = NULL)
}\if{html}{\out{</div>}}
\item \code{enquo0} and \code{enquos0()} are like \code{enquo()} and \code{enquos()} but
without injection support. The injection operators \verb{!!}, \verb{!!!},
and \verb{\{\{} are not processed, instead they are preserved in the
defused expression. This makes it possible to defuse
expressions that potentially contain injection operators meant
for later use. The trade off is that it makes it harder for
users to inject expressions in your function. They have to
enable injection explicitly with \code{\link[=inject]{inject()}}.

None of the features of \link[=dyn-dots]{dynamic dots} are available
when defusing with \code{enquos0()}. For instance, trailing empty
arguments are not automatically trimmed.
}
}
\examples{
# `exprs()` is the plural variant of `expr()`
exprs(foo, bar, bar)

# `quo()` and `quos()` are the quosure variants of `expr()` and `exprs()`
quo(foo)
quos(foo, bar)

# `enexpr()` and `enexprs()` are the naked variants of `enquo()` and `enquos()`
my_function1 <- function(arg) enexpr(arg)
my_function2 <- function(arg, ...) enexprs(arg, ...)
my_function1(1 + 1)
my_function2(1 + 1, 10 * 2)


# `ensym()` and `ensyms()` are symbol variants of `enexpr()` and `enexprs()`
my_function3 <- function(arg) ensym(arg)
my_function4 <- function(arg, ...) ensyms(arg, ...)

# The user must supply symbols
my_function3(foo)
my_function4(foo, bar)

# Complex expressions are an error
try(my_function3(1 + 1))
try(my_function4(1 + 1, 10 * 2))


# `enquo0()` and `enquos0()` disable injection operators
automatic_injection <- function(x) enquo(x)
no_injection <- function(x) enquo0(x)

automatic_injection(foo(!!!1:3))
no_injection(foo(!!!1:3))

# Injection can still be done explicitly
inject(no_injection(foo(!!!1:3)))

}
\keyword{internal}
